/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.protocol.constants.MacAlgorithm;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.CipherAlgorithm;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SessionTicketTLSExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.core.state.SessionTicket;
import de.rub.nds.tlsattacker.core.state.parser.SessionTicketParser;
import java.io.InputStream;

public class SessionTicketTLSExtensionParser
extends ExtensionParser<SessionTicketTLSExtensionMessage> {
    private final byte[] configTicketKeyName;
    private final CipherAlgorithm configCipherAlgorithm;
    private final MacAlgorithm configMacAlgorithm;

    public SessionTicketTLSExtensionParser(InputStream stream, Config config, TlsContext tlsContext) {
        super(stream, tlsContext);
        this.configTicketKeyName = config.getSessionTicketKeyName();
        this.configCipherAlgorithm = config.getSessionTicketCipherAlgorithm();
        this.configMacAlgorithm = config.getSessionTicketMacAlgorithm();
    }

    @Override
    public void parse(SessionTicketTLSExtensionMessage msg) {
        SessionTicket ticket = new SessionTicket();
        msg.setSessionTicket(ticket);
        if (this.getBytesLeft() > 0) {
            SessionTicketParser ticketParser = new SessionTicketParser(0, (byte[])msg.getExtensionContent().getValue(), msg.getSessionTicket(), this.configTicketKeyName, this.configCipherAlgorithm, this.configMacAlgorithm);
            ticketParser.parse(ticket);
        }
    }
}

