/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PSKKeyExchangeModesExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PSKKeyExchangeModesExtensionParser
extends ExtensionParser<PSKKeyExchangeModesExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PSKKeyExchangeModesExtensionParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(PSKKeyExchangeModesExtensionMessage msg) {
        LOGGER.debug("Parsing PSKKeyExchangeModesExtensionMessage");
        this.parseExchangeModesListLength(msg);
        this.parseExchangeModesBytes(msg);
        msg.setKeyExchangeModesConfig((byte[])msg.getKeyExchangeModesListBytes().getValue());
    }

    private void parseExchangeModesListLength(PSKKeyExchangeModesExtensionMessage msg) {
        msg.setKeyExchangeModesListLength(this.parseIntField(1));
        LOGGER.debug("PSKKeyModesList length:: {}", msg.getKeyExchangeModesListLength().getValue());
    }

    private void parseExchangeModesBytes(PSKKeyExchangeModesExtensionMessage msg) {
        msg.setKeyExchangeModesListBytes(this.parseByteArrayField((Integer)msg.getKeyExchangeModesListLength().getValue()));
        LOGGER.debug("PSKKeyModesList bytes: {}", msg.getKeyExchangeModesListBytes().getValue());
    }
}

