/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerVerifyMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.SSL2MessageParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSL2ServerVerifyParser
extends SSL2MessageParser<SSL2ServerVerifyMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SSL2ServerVerifyParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(SSL2ServerVerifyMessage msg) {
        LOGGER.debug("Parsing SSL2ServerVerify");
        this.parseEncryptedPart(msg);
    }

    private void parseEncryptedPart(SSL2ServerVerifyMessage message) {
        message.setEncryptedPart(this.parseByteArrayField((Integer)message.getMessageLength().getValue()));
        LOGGER.debug("Encrypted Part: {}", message.getEncryptedPart().getValue());
    }
}

