/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.SSL2MessageParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSL2ServerHelloParser
extends SSL2MessageParser<SSL2ServerHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SSL2ServerHelloParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(SSL2ServerHelloMessage message) {
        LOGGER.debug("Parsing SSL2ServerHello");
        this.parseSessionIdHit(message);
        this.parseCertificateType(message);
        this.parseProtocolVersion(message);
        this.parseCertificateLength(message);
        this.parseCipherSuitesLength(message);
        this.parseSessionIDLength(message);
        this.parseCertificate(message);
        this.parseCipherSuites(message);
        this.parseSessionID(message);
    }

    private void parseSessionIdHit(SSL2ServerHelloMessage message) {
        message.setSessionIdHit(this.parseByteField(1));
        LOGGER.debug("SessionIdHit: {}", message.getSessionIdHit().getValue());
    }

    private void parseCertificateType(SSL2ServerHelloMessage message) {
        message.setCertificateType(this.parseByteField(1));
        LOGGER.debug("CertificateType: {}", message.getCertificateType().getValue());
    }

    private void parseProtocolVersion(SSL2ServerHelloMessage message) {
        message.setProtocolVersion(this.parseByteArrayField(2));
        LOGGER.debug("ProtocolVersion: {}", message.getProtocolVersion().getValue());
    }

    private void parseCertificateLength(SSL2ServerHelloMessage message) {
        message.setCertificateLength(this.parseIntField(2));
        LOGGER.debug("CertificateLength: {}", message.getCertificateLength().getValue());
    }

    private void parseCipherSuitesLength(SSL2ServerHelloMessage message) {
        message.setCipherSuitesLength(this.parseIntField(2));
        LOGGER.debug("CipherSuitesLength: {}", message.getCipherSuitesLength().getValue());
    }

    private void parseSessionIDLength(SSL2ServerHelloMessage message) {
        message.setSessionIDLength(this.parseIntField(2));
        LOGGER.debug("SessionIDLength: {}", message.getSessionIdLength().getValue());
    }

    private void parseCertificate(SSL2ServerHelloMessage message) {
        message.setCertificate(this.parseByteArrayField((Integer)message.getCertificateLength().getValue()));
        LOGGER.debug("Certificate: {}", message.getCertificate().getValue());
    }

    private void parseCipherSuites(SSL2ServerHelloMessage message) {
        message.setCipherSuites(this.parseByteArrayField((Integer)message.getCipherSuitesLength().getValue()));
        LOGGER.debug("CipherSuites: {}", message.getCipherSuites().getValue());
    }

    private void parseSessionID(SSL2ServerHelloMessage message) {
        message.setSessionID(this.parseByteArrayField((Integer)message.getSessionIdLength().getValue()));
        LOGGER.debug("SessionID: {}", message.getSessionId().getValue());
    }
}

