/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.PskRsaClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.RSAClientKeyExchangeParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskRsaClientKeyExchangeParser
extends RSAClientKeyExchangeParser<PskRsaClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PskRsaClientKeyExchangeParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(PskRsaClientKeyExchangeMessage msg) {
        LOGGER.debug("Parsing PSKRSAClientKeyExchangeMessage");
        this.parsePskIdentityLength(msg);
        this.parsePskIdentity(msg);
        super.parseRsaParams(msg);
    }

    private void parsePskIdentityLength(PskRsaClientKeyExchangeMessage msg) {
        msg.setIdentityLength(this.parseIntField(2));
        LOGGER.debug("PSK-IdentityLength: {}", msg.getIdentityLength().getValue());
    }

    private void parsePskIdentity(PskRsaClientKeyExchangeMessage msg) {
        msg.setIdentity(this.parseByteArrayField((Integer)msg.getIdentityLength().getValue()));
        LOGGER.debug("PSK-Identity: {}", msg.getIdentity().getValue());
    }
}

