/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.PskEcDhClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ECDHClientKeyExchangeParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskEcDhClientKeyExchangeParser
extends ECDHClientKeyExchangeParser<PskEcDhClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PskEcDhClientKeyExchangeParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(PskEcDhClientKeyExchangeMessage msg) {
        LOGGER.debug("Parsing PskEcDhClientKeyExchangeMessage");
        this.parsePskIdentityLength(msg);
        this.parsePskIdentity(msg);
        super.parseEcDhParams(msg);
    }

    private void parsePskIdentityLength(PskEcDhClientKeyExchangeMessage msg) {
        msg.setIdentityLength(this.parseIntField(2));
        LOGGER.debug("PSK-IdentityLength: {}", msg.getIdentityLength().getValue());
    }

    private void parsePskIdentity(PskEcDhClientKeyExchangeMessage msg) {
        msg.setIdentity(this.parseByteArrayField((Integer)msg.getIdentityLength().getValue()));
        LOGGER.debug("SerializedPSK-Identity: {}", msg.getIdentity().getValue());
    }
}

