/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.constants.KeyUpdateRequest;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.KeyUpdateMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyUpdateParser
extends HandshakeMessageParser<KeyUpdateMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public KeyUpdateParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext.getChooser().getSelectedProtocolVersion(), tlsContext);
    }

    @Override
    public void parse(KeyUpdateMessage msg) {
        LOGGER.debug("Parsing KeyUpdateMessage");
        this.parseUpdateRequest(msg);
    }

    private void parseUpdateRequest(KeyUpdateMessage msg) {
        byte requestMode = this.parseByteField(1);
        if (requestMode == KeyUpdateRequest.UPDATE_REQUESTED.getValue()) {
            msg.setRequestMode(KeyUpdateRequest.UPDATE_REQUESTED);
        } else {
            msg.setRequestMode(KeyUpdateRequest.UPDATE_NOT_REQUESTED);
        }
        LOGGER.debug("KeyUpdateValue: {}", msg.getRequestMode().getValue());
    }
}

