/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.extension;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.EchConfigVersion;
import de.rub.nds.tlsattacker.core.constants.EchVersion;
import de.rub.nds.tlsattacker.core.constants.hpke.HpkeAeadFunction;
import de.rub.nds.tlsattacker.core.constants.hpke.HpkeKeyDerivationFunction;
import de.rub.nds.tlsattacker.core.constants.hpke.HpkeKeyEncapsulationMechanism;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ech.HpkeCipherSuite;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EchConfig
implements Serializable {
    @XmlTransient
    private boolean isDefault = false;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] echConfigBytes;
    private EchConfigVersion configVersion;
    private int length;
    private int maximumNameLength;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] publicDomainName;
    @XmlElement(name="extension")
    @XmlElementWrapper
    private List<ExtensionMessage> extensions = new LinkedList<ExtensionMessage>();
    private int configId;
    private HpkeKeyEncapsulationMechanism kem;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] hpkePublicKey;
    @XmlElement(name="hpkeCipherSuite")
    @XmlElementWrapper
    private List<HpkeCipherSuite> hpkeCipherSuites;
    @XmlElement(name="cipherSuite")
    @XmlElementWrapper
    private List<CipherSuite> cipherSuites;

    public static EchConfig createDefaultEchConfig() {
        EchConfig echConfig = new EchConfig();
        echConfig.isDefault = true;
        echConfig.setEchConfigBytes(DataConverter.hexStringToByteArray((String)"FE0D003AB8002000205611F61F4F5F5C801C60009DA68DD0EB0DD5DBA8FF33C32D5025D7FFADF5DC6F000400010001000B6578616D706C652E636F6D0000"));
        echConfig.setConfigVersion(EchVersion.DRAFT_14.getEchConfigVersion());
        echConfig.setLength(58);
        echConfig.setMaximumNameLength(0);
        echConfig.setPublicDomainName(DataConverter.hexStringToByteArray((String)"6578616D706C652E636F6D"));
        echConfig.setExtensions(new LinkedList<ExtensionMessage>());
        echConfig.setConfigId(184);
        echConfig.setKem(HpkeKeyEncapsulationMechanism.DHKEM_X25519_HKDF_SHA256);
        echConfig.setHpkePublicKey(DataConverter.hexStringToByteArray((String)"5611F61F4F5F5C801C60009DA68DD0EB0DD5DBA8FF33C32D5025D7FFADF5DC6F"));
        echConfig.setCipherSuites(new LinkedList<CipherSuite>());
        HpkeCipherSuite hpkeCipherSuite = new HpkeCipherSuite(HpkeKeyDerivationFunction.HKDF_SHA256, HpkeAeadFunction.AES_128_GCM);
        echConfig.setHpkeCipherSuites(List.of(hpkeCipherSuite));
        return echConfig;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public byte[] getEchConfigBytes() {
        return this.echConfigBytes;
    }

    public void setEchConfigBytes(byte[] echConfigBytes) {
        this.echConfigBytes = echConfigBytes;
    }

    public EchConfigVersion getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(EchConfigVersion configVersion) {
        this.configVersion = configVersion;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getMaximumNameLength() {
        return this.maximumNameLength;
    }

    public void setMaximumNameLength(int maximumNameLength) {
        this.maximumNameLength = maximumNameLength;
    }

    public byte[] getPublicDomainName() {
        return this.publicDomainName;
    }

    public void setPublicDomainName(byte[] publicDomainName) {
        this.publicDomainName = publicDomainName;
    }

    public List<ExtensionMessage> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<ExtensionMessage> extensions) {
        this.extensions = extensions;
    }

    public int getConfigId() {
        return this.configId;
    }

    public void setConfigId(int configId) {
        this.configId = configId;
    }

    public HpkeKeyEncapsulationMechanism getKem() {
        return this.kem;
    }

    public void setKem(HpkeKeyEncapsulationMechanism kem) {
        this.kem = kem;
    }

    public byte[] getHpkePublicKey() {
        return this.hpkePublicKey;
    }

    public void setHpkePublicKey(byte[] hpkePublicKey) {
        this.hpkePublicKey = hpkePublicKey;
    }

    public List<HpkeCipherSuite> getHpkeCipherSuites() {
        return this.hpkeCipherSuites;
    }

    public void setHpkeCipherSuites(List<HpkeCipherSuite> hpkeCipherSuites) {
        this.hpkeCipherSuites = hpkeCipherSuites;
    }

    public List<CipherSuite> getCipherSuites() {
        return this.cipherSuites;
    }

    public HpkeAeadFunction getHpkeAeadFunction() {
        return this.hpkeCipherSuites.get(0).getAeadFunction();
    }

    public HpkeKeyDerivationFunction getHpkeKeyDerivationFunction() {
        return this.hpkeCipherSuites.get(0).getKeyDerivationFunction();
    }

    public void setCipherSuites(List<CipherSuite> cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EchConfig echConfig = (EchConfig)o;
        return this.length == echConfig.length && this.maximumNameLength == echConfig.maximumNameLength && this.configId == echConfig.configId && Arrays.equals(this.echConfigBytes, echConfig.echConfigBytes) && this.configVersion == echConfig.configVersion && Arrays.equals(this.publicDomainName, echConfig.publicDomainName) && Objects.equals(this.extensions, echConfig.extensions) && this.kem == echConfig.kem && Arrays.equals(this.hpkePublicKey, echConfig.hpkePublicKey) && Objects.equals(this.hpkeCipherSuites, echConfig.hpkeCipherSuites) && Objects.equals(this.cipherSuites, echConfig.cipherSuites);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.configVersion, this.length, this.maximumNameLength, this.extensions, this.configId, this.kem, this.hpkeCipherSuites, this.cipherSuites});
        result = 31 * result + Arrays.hashCode(this.echConfigBytes);
        result = 31 * result + Arrays.hashCode(this.publicDomainName);
        result = 31 * result + Arrays.hashCode(this.hpkePublicKey);
        return result;
    }
}

