/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.cert;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableHolder;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.context.X509Context;
import de.rub.nds.x509attacker.x509.model.X509Certificate;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class CertificateEntry
extends ModifiableVariableHolder {
    private static final Logger LOGGER = LogManager.getLogger();
    private List<ExtensionMessage> extensionList;
    @ModifiableVariableProperty
    private ModifiableByteArray certificateBytes;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger certificateLength;
    @ModifiableVariableProperty
    private ModifiableByteArray extensionBytes;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger extensionsLength;
    private X509Certificate x509certificate;
    private byte[] x509CerticiateConfig;

    public CertificateEntry() {
    }

    public CertificateEntry(byte[] x509CertificateConfig) {
        this.x509CerticiateConfig = x509CertificateConfig;
        try {
            X509Context context = new X509Context();
            X509Chooser chooser = context.getChooser();
            this.x509certificate = new X509Certificate("certificate");
            this.x509certificate.getParser(chooser).parse(new BufferedInputStream(new ByteArrayInputStream(this.x509CerticiateConfig)));
        }
        catch (Exception E) {
            LOGGER.warn("Could not parse a valid certificate from provided certificate bytes");
            this.x509certificate = null;
        }
    }

    public CertificateEntry(X509Certificate x509Certificate) {
        this.x509certificate = x509Certificate;
    }

    public byte[] getX509CerticiateConfig() {
        return this.x509CerticiateConfig;
    }

    public void setX509CerticiateConfig(byte[] x509CerticiateConfig) {
        this.x509CerticiateConfig = x509CerticiateConfig;
    }

    public X509Certificate getX509certificate() {
        return this.x509certificate;
    }

    public void setX509certificate(X509Certificate x509certificate) {
        this.x509certificate = x509certificate;
    }

    public ModifiableByteArray getCertificateBytes() {
        return this.certificateBytes;
    }

    public void setCertificateBytes(ModifiableByteArray certificateBytes) {
        this.certificateBytes = certificateBytes;
    }

    public void setCertificateBytes(byte[] certificateBytes) {
        this.certificateBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.certificateBytes, (byte[])certificateBytes);
    }

    public ModifiableInteger getCertificateLength() {
        return this.certificateLength;
    }

    public void setCertificateLength(ModifiableInteger serverNameLength) {
        this.certificateLength = serverNameLength;
    }

    public void setCertificateLength(int certificateLength) {
        this.certificateLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.certificateLength, (Integer)certificateLength);
    }

    public ModifiableByteArray getExtensionBytes() {
        return this.extensionBytes;
    }

    public void setExtensionBytes(ModifiableByteArray extensionBytes) {
        this.certificateBytes = extensionBytes;
    }

    public void setExtensionBytes(byte[] extensionBytes) {
        this.extensionBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.extensionBytes, (byte[])extensionBytes);
    }

    public ModifiableInteger getExtensionsLength() {
        return this.extensionsLength;
    }

    public void setExtensionsLength(ModifiableInteger extensionsLength) {
        this.extensionsLength = extensionsLength;
    }

    public void setExtensionsLength(int extensionsLength) {
        this.extensionsLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.extensionsLength, (Integer)extensionsLength);
    }

    public List<ExtensionMessage> getExtensionList() {
        return this.extensionList;
    }

    public void setExtensionList(List<ExtensionMessage> extensionList) {
        this.extensionList = extensionList;
    }

    public void addExtension(ExtensionMessage extension) {
        if (this.extensionList == null) {
            this.extensionList = new LinkedList<ExtensionMessage>();
        }
        this.extensionList.add(extension);
    }
}

