/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.UnknownHandshakeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.UnknownHandshakeParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.UnknownHandshakePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.UnknownHandshakeSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;

@XmlRootElement(name="UnknownHandshakeMessage")
public class UnknownHandshakeMessage
extends HandshakeMessage {
    private byte[] dataConfig;
    private ModifiableByte assumedType;
    @ModifiableVariableProperty
    private ModifiableByteArray data;

    public UnknownHandshakeMessage() {
        super(HandshakeMessageType.UNKNOWN);
    }

    public byte[] getDataConfig() {
        return this.dataConfig;
    }

    public void setDataConfig(byte[] dataConfig) {
        this.dataConfig = dataConfig;
    }

    public ModifiableByteArray getData() {
        return this.data;
    }

    public void setData(ModifiableByteArray data) {
        this.data = data;
    }

    public void setData(byte[] data) {
        this.data = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.data, (byte[])data);
    }

    @Override
    public UnknownHandshakeHandler getHandler(Context context) {
        return new UnknownHandshakeHandler(context.getTlsContext());
    }

    @Override
    public UnknownHandshakeParser getParser(Context context, InputStream stream) {
        return new UnknownHandshakeParser(stream, context.getTlsContext());
    }

    @Override
    public UnknownHandshakePreparator getPreparator(Context context) {
        return new UnknownHandshakePreparator(context.getChooser(), this);
    }

    @Override
    public UnknownHandshakeSerializer getSerializer(Context context) {
        return new UnknownHandshakeSerializer(this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UnknownHandshakeMessage:");
        sb.append("\n  Data: ");
        if (this.data != null && this.data.getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.data.getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toCompactString() {
        if (this.assumedType == null || ((Byte)this.assumedType.getValue()).byteValue() == HandshakeMessageType.UNKNOWN.getValue()) {
            return super.toCompactString();
        }
        HandshakeMessageType assumedHandshakeType = HandshakeMessageType.getMessageType((Byte)this.assumedType.getValue());
        return super.toCompactString() + "(" + String.valueOf((Object)assumedHandshakeType) + "?)";
    }

    @Override
    public String toShortString() {
        if (this.assumedType == null || ((Byte)this.assumedType.getValue()).byteValue() == HandshakeMessageType.UNKNOWN.getValue()) {
            return "HS(?)";
        }
        return "HS(" + String.valueOf(this.assumedType.getValue()) + "?)";
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Arrays.hashCode(this.dataConfig);
        hash = 17 * hash + Objects.hashCode(this.data);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnknownHandshakeMessage other = (UnknownHandshakeMessage)obj;
        if (!Arrays.equals(this.dataConfig, other.dataConfig)) {
            return false;
        }
        return Objects.equals(this.data, other.data);
    }

    public void setAssumedType(ModifiableByte assumedType) {
        this.assumedType = assumedType;
    }

    public void setAssumedType(byte assumedType) {
        this.assumedType = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.getAssumedType(), (Byte)assumedType);
    }

    public ModifiableByte getAssumedType() {
        return this.assumedType;
    }
}

