/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.handler.ServerHelloHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.AlpnExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CachedInfoExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CertificateStatusRequestExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CertificateStatusRequestV2ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CertificateTypeExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientAuthzExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientCertificateTypeExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientCertificateUrlExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ConnectionIdExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CookieExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ECPointFormatExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptThenMacExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptedServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtendedMasterSecretExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtendedRandomExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.HeartbeatExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.KeyShareExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.MaxFragmentLengthExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PaddingExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PreSharedKeyExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.RecordSizeLimitExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.RenegotiationInfoExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SRPExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerAuthzExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerCertificateTypeExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SessionTicketTLSExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SignedCertificateTimestampExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SrtpExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SupportedVersionsExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.TokenBindingExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.TruncatedHmacExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.TrustedCaIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.UserMappingExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import de.rub.nds.tlsattacker.core.protocol.parser.ServerHelloParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.ServerHelloPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.ServerHelloSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

@XmlRootElement(name="ServerHello")
public class ServerHelloMessage
extends HelloMessage {
    private static final byte[] HELLO_RETRY_REQUEST_RANDOM = new byte[]{-49, 33, -83, 116, -27, -102, 97, 17, -66, 29, -116, 2, 30, 101, -72, -111, -62, -94, 17, 22, 122, -69, -116, 94, 7, -98, 9, -30, -56, -88, 51, -100};
    @ModifiableVariableProperty
    private ModifiableByteArray selectedCipherSuite;
    @ModifiableVariableProperty
    private ModifiableByte selectedCompressionMethod;
    private Boolean autoSetHelloRetryModeInKeyShare = true;
    private Boolean isHelloRetryRequest = false;

    public static byte[] getHelloRetryRequestRandom() {
        return Arrays.copyOf(HELLO_RETRY_REQUEST_RANDOM, HELLO_RETRY_REQUEST_RANDOM.length);
    }

    public ServerHelloMessage(Config tlsConfig) {
        super(HandshakeMessageType.SERVER_HELLO);
        if (!tlsConfig.isRespectClientProposedExtensions().booleanValue()) {
            this.createConfiguredExtensions(tlsConfig).forEach(this::addExtension);
        }
    }

    public ServerHelloMessage(Config tlsConfig, boolean isHelloRetryRequest) {
        super(HandshakeMessageType.SERVER_HELLO);
        this.isHelloRetryRequest = isHelloRetryRequest;
        if (!tlsConfig.isRespectClientProposedExtensions().booleanValue()) {
            this.createConfiguredExtensions(tlsConfig).forEach(this::addExtension);
        }
    }

    public ServerHelloMessage() {
        super(HandshakeMessageType.SERVER_HELLO);
    }

    @Override
    public final List<ExtensionMessage> createConfiguredExtensions(Config tlsConfig) {
        LinkedList<ExtensionMessage> configuredExtensions = new LinkedList<ExtensionMessage>();
        if (!tlsConfig.getHighestProtocolVersion().isSSL() || tlsConfig.getHighestProtocolVersion().isSSL() && tlsConfig.isAddExtensionsInSSL().booleanValue()) {
            if (tlsConfig.isAddHeartbeatExtension().booleanValue()) {
                configuredExtensions.add(new HeartbeatExtensionMessage());
            }
            if (tlsConfig.isAddECPointFormatExtension().booleanValue() && !tlsConfig.getHighestProtocolVersion().is13()) {
                configuredExtensions.add(new ECPointFormatExtensionMessage());
            }
            if (tlsConfig.isAddMaxFragmentLengthExtension().booleanValue()) {
                configuredExtensions.add(new MaxFragmentLengthExtensionMessage());
            }
            if (tlsConfig.isAddRecordSizeLimitExtension().booleanValue() && !tlsConfig.getHighestProtocolVersion().is13()) {
                configuredExtensions.add(new RecordSizeLimitExtensionMessage());
            }
            if (tlsConfig.isAddServerNameIndicationExtension().booleanValue() && !tlsConfig.isAddEncryptedClientHelloExtension().booleanValue() && !tlsConfig.isAddEncryptedServerNameIndicationExtension().booleanValue()) {
                ServerNameIndicationExtensionMessage extension = new ServerNameIndicationExtensionMessage();
                ServerNamePair pair = new ServerNamePair(tlsConfig.getSniType().getValue(), tlsConfig.getDefaultServerConnection().getHostname().getBytes(Charset.forName("US-ASCII")));
                extension.getServerNameList().add(pair);
                configuredExtensions.add(extension);
            }
            if (tlsConfig.isAddKeyShareExtension().booleanValue()) {
                configuredExtensions.add(new KeyShareExtensionMessage(tlsConfig));
            }
            if (tlsConfig.isAddEncryptedServerNameIndicationExtension().booleanValue()) {
                configuredExtensions.add(new EncryptedServerNameIndicationExtensionMessage());
            }
            if (tlsConfig.isAddExtendedMasterSecretExtension().booleanValue()) {
                configuredExtensions.add(new ExtendedMasterSecretExtensionMessage());
            }
            if (tlsConfig.isAddSessionTicketTLSExtension().booleanValue()) {
                configuredExtensions.add(new SessionTicketTLSExtensionMessage());
            }
            if (tlsConfig.isAddSignedCertificateTimestampExtension().booleanValue()) {
                configuredExtensions.add(new SignedCertificateTimestampExtensionMessage());
            }
            if (tlsConfig.isAddPaddingExtension().booleanValue()) {
                configuredExtensions.add(new PaddingExtensionMessage());
            }
            if (tlsConfig.isAddRenegotiationInfoExtension().booleanValue()) {
                configuredExtensions.add(new RenegotiationInfoExtensionMessage());
            }
            if (tlsConfig.isAddTokenBindingExtension().booleanValue()) {
                configuredExtensions.add(new TokenBindingExtensionMessage());
            }
            if (tlsConfig.isAddCertificateStatusRequestExtension().booleanValue()) {
                configuredExtensions.add(new CertificateStatusRequestExtensionMessage());
            }
            if (tlsConfig.isAddAlpnExtension().booleanValue()) {
                configuredExtensions.add(new AlpnExtensionMessage());
            }
            if (tlsConfig.isAddSRPExtension().booleanValue()) {
                configuredExtensions.add(new SRPExtensionMessage());
            }
            if (tlsConfig.isAddSRTPExtension().booleanValue()) {
                configuredExtensions.add(new SrtpExtensionMessage());
            }
            if (tlsConfig.isAddTruncatedHmacExtension().booleanValue()) {
                configuredExtensions.add(new TruncatedHmacExtensionMessage());
            }
            if (tlsConfig.isAddUserMappingExtension().booleanValue()) {
                configuredExtensions.add(new UserMappingExtensionMessage());
            }
            if (tlsConfig.isAddCertificateTypeExtension().booleanValue()) {
                configuredExtensions.add(new CertificateTypeExtensionMessage());
            }
            if (tlsConfig.isAddClientAuthzExtension().booleanValue()) {
                configuredExtensions.add(new ClientAuthzExtensionMessage());
            }
            if (tlsConfig.isAddServerAuthzExtension().booleanValue()) {
                configuredExtensions.add(new ServerAuthzExtensionMessage());
            }
            if (tlsConfig.isAddClientCertificateTypeExtension().booleanValue()) {
                configuredExtensions.add(new ClientCertificateTypeExtensionMessage());
            }
            if (tlsConfig.isAddServerCertificateTypeExtension().booleanValue()) {
                configuredExtensions.add(new ServerCertificateTypeExtensionMessage());
            }
            if (tlsConfig.isAddEncryptThenMacExtension().booleanValue()) {
                configuredExtensions.add(new EncryptThenMacExtensionMessage());
            }
            if (tlsConfig.isAddCachedInfoExtension().booleanValue()) {
                configuredExtensions.add(new CachedInfoExtensionMessage());
            }
            if (tlsConfig.isAddClientCertificateUrlExtension().booleanValue()) {
                configuredExtensions.add(new ClientCertificateUrlExtensionMessage());
            }
            if (tlsConfig.isAddTrustedCaIndicationExtension().booleanValue()) {
                configuredExtensions.add(new TrustedCaIndicationExtensionMessage());
            }
            if (tlsConfig.isAddCertificateStatusRequestV2Extension().booleanValue()) {
                configuredExtensions.add(new CertificateStatusRequestV2ExtensionMessage());
            }
            if (tlsConfig.isAddPreSharedKeyExtension().booleanValue()) {
                configuredExtensions.add(new PreSharedKeyExtensionMessage(tlsConfig));
            }
            if (tlsConfig.isAddSupportedVersionsExtension().booleanValue()) {
                configuredExtensions.add(new SupportedVersionsExtensionMessage());
            }
            if (tlsConfig.isAddExtendedRandomExtension().booleanValue()) {
                configuredExtensions.add(new ExtendedRandomExtensionMessage());
            }
            if (tlsConfig.isAddCookieExtension().booleanValue()) {
                configuredExtensions.add(new CookieExtensionMessage());
            }
            if (tlsConfig.isAddConnectionIdExtension().booleanValue()) {
                configuredExtensions.add(new ConnectionIdExtensionMessage());
            }
        }
        return configuredExtensions;
    }

    public Boolean isHelloRetryRequest() {
        return this.isHelloRetryRequest;
    }

    public void setHelloRetryRequest(Boolean helloRetryRequest) {
        this.isHelloRetryRequest = helloRetryRequest;
    }

    public ModifiableByteArray getSelectedCipherSuite() {
        return this.selectedCipherSuite;
    }

    public void setSelectedCipherSuite(ModifiableByteArray selectedCipherSuite) {
        this.selectedCipherSuite = selectedCipherSuite;
    }

    public void setSelectedCipherSuite(byte[] value) {
        this.selectedCipherSuite = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.selectedCipherSuite, (byte[])value);
    }

    public ModifiableByte getSelectedCompressionMethod() {
        return this.selectedCompressionMethod;
    }

    public void setSelectedCompressionMethod(ModifiableByte selectedCompressionMethod) {
        this.selectedCompressionMethod = selectedCompressionMethod;
    }

    public void setSelectedCompressionMethod(byte value) {
        this.selectedCompressionMethod = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.selectedCompressionMethod, (Byte)value);
    }

    public Boolean hasTls13HelloRetryRequestRandom() {
        if (this.getRandom() != null && this.getRandom().getValue() != null) {
            return Arrays.equals((byte[])this.getRandom().getValue(), HELLO_RETRY_REQUEST_RANDOM);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\n  Protocol Version: ");
        if (this.getProtocolVersion() != null) {
            sb.append((Object)ProtocolVersion.getProtocolVersion((byte[])this.getProtocolVersion().getValue()));
        } else {
            sb.append("null");
        }
        if (this.getProtocolVersion() != null && this.getProtocolVersion().getValue() != null && !ProtocolVersion.getProtocolVersion((byte[])this.getProtocolVersion().getValue()).is13()) {
            sb.append("\n  Server Unix Time: ").append(new Date(DataConverter.bytesToLong((byte[])((byte[])this.getUnixTime().getValue())) * 1000L));
        }
        sb.append("\n  Server Unix Time: ");
        if (this.getProtocolVersion() != null) {
            if (!ProtocolVersion.getProtocolVersion((byte[])this.getProtocolVersion().getValue()).is13()) {
                sb.append(new Date(DataConverter.bytesToLong((byte[])((byte[])this.getUnixTime().getValue())) * 1000L));
            } else {
                sb.append("null");
            }
        } else {
            sb.append("null");
        }
        sb.append("\n  Server Random: ");
        if (this.getRandom() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.getRandom().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Session ID: ");
        if (this.getProtocolVersion() != null && this.getProtocolVersion().getValue() != null) {
            if (!ProtocolVersion.getProtocolVersion((byte[])this.getProtocolVersion().getValue()).is13()) {
                sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.getSessionId().getValue())));
            } else {
                sb.append("null");
            }
        } else {
            sb.append("null");
        }
        sb.append("\n  Selected Cipher Suite: ");
        if (this.selectedCipherSuite != null && this.selectedCipherSuite.getValue() != null) {
            sb.append((Object)CipherSuite.getCipherSuite((byte[])this.selectedCipherSuite.getValue()));
        } else {
            sb.append("null");
        }
        sb.append("\n  Selected Compression Method: ");
        if (this.getProtocolVersion() != null && this.getProtocolVersion().getValue() != null) {
            if (!ProtocolVersion.getProtocolVersion((byte[])this.getProtocolVersion().getValue()).is13()) {
                sb.append((Object)CompressionMethod.getCompressionMethod((Byte)this.selectedCompressionMethod.getValue()));
            } else {
                sb.append("null");
            }
        } else {
            sb.append("null");
        }
        sb.append("\n  Extensions: ");
        if (this.getExtensions() == null) {
            sb.append("null");
        } else {
            for (ExtensionMessage e : this.getExtensions()) {
                sb.append(e.toString());
            }
        }
        return sb.toString();
    }

    @Override
    public ServerHelloHandler getHandler(Context context) {
        return new ServerHelloHandler(context.getTlsContext());
    }

    @Override
    public ServerHelloPreparator getPreparator(Context context) {
        return new ServerHelloPreparator(context.getChooser(), this);
    }

    @Override
    public ServerHelloSerializer getSerializer(Context context) {
        return new ServerHelloSerializer(this);
    }

    @Override
    public ServerHelloParser getParser(Context context, InputStream stream) {
        return new ServerHelloParser(stream, context.getTlsContext());
    }

    public Boolean isAutoSetHelloRetryModeInKeyShare() {
        return this.autoSetHelloRetryModeInKeyShare;
    }

    public void setAutoSetHelloRetryModeInKeyShare(Boolean autoSetHelloRetryModeInKeyShare) {
        this.autoSetHelloRetryModeInKeyShare = autoSetHelloRetryModeInKeyShare;
    }

    public boolean setRetryRequestModeInKeyShare() {
        return Boolean.TRUE.equals(this.hasTls13HelloRetryRequestRandom()) && this.autoSetHelloRetryModeInKeyShare != false;
    }

    @Override
    public String toCompactString() {
        Boolean isHrr = this.hasTls13HelloRetryRequestRandom();
        Object compactString = super.toCompactString();
        if (isHrr != null && isHrr.booleanValue()) {
            compactString = (String)compactString + "(HRR)";
        }
        return compactString;
    }

    @Override
    public String toShortString() {
        if (this.hasTls13HelloRetryRequestRandom().booleanValue()) {
            return "HRR";
        }
        return "SH";
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.selectedCipherSuite);
        hash = 89 * hash + Objects.hashCode(this.selectedCompressionMethod);
        hash = 89 * hash + Objects.hashCode(this.autoSetHelloRetryModeInKeyShare);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerHelloMessage other = (ServerHelloMessage)obj;
        if (!Objects.equals(this.selectedCipherSuite, other.selectedCipherSuite)) {
            return false;
        }
        if (!Objects.equals(this.selectedCompressionMethod, other.selectedCompressionMethod)) {
            return false;
        }
        return Objects.equals(this.autoSetHelloRetryModeInKeyShare, other.autoSetHelloRetryModeInKeyShare);
    }
}

