/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.constants.SSL2MessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.SSL2ServerVerifyHandler;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2Message;
import de.rub.nds.tlsattacker.core.protocol.parser.SSL2ServerVerifyParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.SSL2ServerVerifyPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.SSL2MessageSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.Objects;

@XmlRootElement(name="SSL2ServerVerify")
public class SSL2ServerVerifyMessage
extends SSL2Message {
    @ModifiableVariableProperty
    private ModifiableByteArray encryptedPart;

    public SSL2ServerVerifyMessage() {
        super(SSL2MessageType.SSL_SERVER_VERIFY);
        this.protocolMessageType = ProtocolMessageType.HANDSHAKE;
    }

    @Override
    public String toCompactString() {
        return "SSL2 ServerVerify Message";
    }

    @Override
    public String toShortString() {
        return "SSL2_SV";
    }

    @Override
    public SSL2ServerVerifyHandler getHandler(Context context) {
        return new SSL2ServerVerifyHandler(context.getTlsContext());
    }

    @Override
    public SSL2ServerVerifyParser getParser(Context context, InputStream stream) {
        return new SSL2ServerVerifyParser(stream, context.getTlsContext());
    }

    @Override
    public SSL2ServerVerifyPreparator getPreparator(Context context) {
        return new SSL2ServerVerifyPreparator(context.getChooser(), this);
    }

    @Override
    public SSL2MessageSerializer<SSL2ServerVerifyMessage> getSerializer(Context context) {
        return null;
    }

    public ModifiableByteArray getEncryptedPart() {
        return this.encryptedPart;
    }

    public void setEncryptedPart(ModifiableByteArray encryptedPart) {
        this.encryptedPart = encryptedPart;
    }

    public void setEncryptedPart(byte[] encryptedPart) {
        this.encryptedPart = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.encryptedPart, (byte[])encryptedPart);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.encryptedPart);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SSL2ServerVerifyMessage other = (SSL2ServerVerifyMessage)obj;
        return Objects.equals(this.encryptedPart, other.encryptedPart);
    }
}

