/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.SSL2MessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.SSL2ClientHelloHandler;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2Message;
import de.rub.nds.tlsattacker.core.protocol.parser.SSL2ClientHelloParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.SSL2ClientHelloPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.SSL2ClientHelloSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.Objects;

@XmlRootElement(name="SSL2ClientHello")
public class SSL2ClientHelloMessage
extends SSL2Message {
    @ModifiableVariableProperty
    private ModifiableByteArray protocolVersion;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger cipherSuiteLength;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger sessionIdLength;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger challengeLength;
    @ModifiableVariableProperty
    private ModifiableByteArray cipherSuites;
    private ModifiableByteArray sessionId;
    @ModifiableVariableProperty
    private ModifiableByteArray challenge;

    public SSL2ClientHelloMessage() {
        super(SSL2MessageType.SSL_CLIENT_HELLO);
    }

    @Override
    public String toCompactString() {
        return "SSL2 ClientHello Message";
    }

    public ModifiableByteArray getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(ModifiableByteArray protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setProtocolVersion(byte[] protocolVersion) {
        this.protocolVersion = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.protocolVersion, (byte[])protocolVersion);
    }

    public ModifiableInteger getCipherSuiteLength() {
        return this.cipherSuiteLength;
    }

    public void setCipherSuiteLength(ModifiableInteger cipherSuiteLength) {
        this.cipherSuiteLength = cipherSuiteLength;
    }

    public void setCipherSuiteLength(int cipherSuiteLength) {
        this.cipherSuiteLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.cipherSuiteLength, (Integer)cipherSuiteLength);
    }

    public ModifiableByteArray getCipherSuites() {
        return this.cipherSuites;
    }

    public void setCipherSuites(ModifiableByteArray cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public void setCipherSuites(byte[] cipherSuites) {
        this.cipherSuites = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.cipherSuites, (byte[])cipherSuites);
    }

    public ModifiableByteArray getChallenge() {
        return this.challenge;
    }

    public void setChallenge(ModifiableByteArray challenge) {
        this.challenge = challenge;
    }

    public void setChallenge(byte[] challenge) {
        this.challenge = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.challenge, (byte[])challenge);
    }

    public ModifiableInteger getSessionIdLength() {
        return this.sessionIdLength;
    }

    public void setSessionIdLength(ModifiableInteger sessionIdLength) {
        this.sessionIdLength = sessionIdLength;
    }

    public void setSessionIDLength(int sessionIDLength) {
        this.sessionIdLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.sessionIdLength, (Integer)sessionIDLength);
    }

    public ModifiableInteger getChallengeLength() {
        return this.challengeLength;
    }

    public void setChallengeLength(int challengeLength) {
        this.challengeLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.challengeLength, (Integer)challengeLength);
    }

    public void setChallengeLength(ModifiableInteger challengeLength) {
        this.challengeLength = challengeLength;
    }

    public ModifiableByteArray getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(ModifiableByteArray sessionId) {
        this.sessionId = sessionId;
    }

    public void setSessionID(byte[] sessionID) {
        this.sessionId = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.sessionId, (byte[])sessionID);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SSL2ClientHelloMessage:");
        sb.append("\n  Protocol Version: ");
        if (this.getProtocolVersion() != null && this.getProtocolVersion().getValue() != null) {
            sb.append((Object)ProtocolVersion.getProtocolVersion((byte[])this.getProtocolVersion().getValue()));
        } else {
            sb.append("null");
        }
        sb.append("\n  Type: ");
        if (this.getType() != null && this.getType().getValue() != null) {
            sb.append(this.getType().getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  Supported CipherSuites: ");
        if (this.getCipherSuites() != null && this.getCipherSuites().getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.getCipherSuites().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Challenge: ");
        if (this.getChallenge() != null && this.getChallenge().getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.getChallenge().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  SessionID: ");
        if (this.getSessionId() != null && this.getSessionId().getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.getSessionId().getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "SSL2_CH";
    }

    @Override
    public SSL2ClientHelloHandler getHandler(Context context) {
        return new SSL2ClientHelloHandler(context.getTlsContext());
    }

    @Override
    public SSL2ClientHelloParser getParser(Context context, InputStream stream) {
        return new SSL2ClientHelloParser(stream, context.getTlsContext());
    }

    @Override
    public SSL2ClientHelloPreparator getPreparator(Context context) {
        return new SSL2ClientHelloPreparator(context.getChooser(), this);
    }

    @Override
    public SSL2ClientHelloSerializer getSerializer(Context context) {
        return new SSL2ClientHelloSerializer(this);
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.protocolVersion);
        hash = 89 * hash + Objects.hashCode(this.cipherSuiteLength);
        hash = 89 * hash + Objects.hashCode(this.sessionIdLength);
        hash = 89 * hash + Objects.hashCode(this.challengeLength);
        hash = 89 * hash + Objects.hashCode(this.cipherSuites);
        hash = 89 * hash + Objects.hashCode(this.sessionId);
        hash = 89 * hash + Objects.hashCode(this.challenge);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SSL2ClientHelloMessage other = (SSL2ClientHelloMessage)obj;
        if (!Objects.equals(this.protocolVersion, other.protocolVersion)) {
            return false;
        }
        if (!Objects.equals(this.cipherSuiteLength, other.cipherSuiteLength)) {
            return false;
        }
        if (!Objects.equals(this.sessionIdLength, other.sessionIdLength)) {
            return false;
        }
        if (!Objects.equals(this.challengeLength, other.challengeLength)) {
            return false;
        }
        if (!Objects.equals(this.cipherSuites, other.cipherSuites)) {
            return false;
        }
        if (!Objects.equals(this.sessionId, other.sessionId)) {
            return false;
        }
        return Objects.equals(this.challenge, other.challenge);
    }
}

