/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableHolder;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.longint.ModifiableLong;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.NewSessionTicketHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EarlyDataExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.NewSessionTicketParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.NewSessionTicketPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.NewSessionTicketSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.core.state.SessionTicket;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;

@XmlRootElement(name="NewSessionTicket")
public class NewSessionTicketMessage
extends HandshakeMessage {
    @ModifiableVariableProperty
    private ModifiableLong ticketLifetimeHint;
    @HoldsModifiableVariable
    private final SessionTicket ticket;

    public NewSessionTicketMessage() {
        super(HandshakeMessageType.NEW_SESSION_TICKET);
        this.ticket = new SessionTicket();
    }

    public NewSessionTicketMessage(boolean required) {
        super(HandshakeMessageType.NEW_SESSION_TICKET);
        this.ticket = new SessionTicket();
        this.setRequired(required);
    }

    public NewSessionTicketMessage(Config tlsConfig, boolean includeInDigest) {
        super(HandshakeMessageType.NEW_SESSION_TICKET);
        this.isIncludeInDigestDefault = includeInDigest;
        this.ticket = new SessionTicket();
        if (tlsConfig.isAddEarlyDataExtension().booleanValue()) {
            this.addExtension(new EarlyDataExtensionMessage(true));
        }
    }

    public ModifiableLong getTicketLifetimeHint() {
        return this.ticketLifetimeHint;
    }

    public void setTicketLifetimeHint(ModifiableLong ticketLifetimeHint) {
        this.ticketLifetimeHint = ticketLifetimeHint;
    }

    public void setTicketLifetimeHint(long ticketLifetimeHint) {
        this.ticketLifetimeHint = ModifiableVariableFactory.safelySetValue((ModifiableLong)this.ticketLifetimeHint, (Long)ticketLifetimeHint);
    }

    public SessionTicket getTicket() {
        return this.ticket;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NewSessionTicketMessage:");
        sb.append("\n  TicketLifeTimeHint: ");
        if (this.ticketLifetimeHint != null && this.ticketLifetimeHint.getValue() != null) {
            sb.append(this.ticketLifetimeHint.getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  TicketLength: ");
        if (this.getTicket().getIdentityLength() != null && this.getTicket().getIdentityLength().getValue() != null) {
            sb.append(this.getTicket().getIdentityLength().getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  Ticket: ");
        if (this.ticket != null) {
            sb.append(this.ticket.toString());
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NEW_SESSION_TICKET");
        if (this.isRetransmission()) {
            sb.append(" (ret.)");
        }
        return sb.toString();
    }

    @Override
    public List<ModifiableVariableHolder> getAllModifiableVariableHolders() {
        List<ModifiableVariableHolder> holders = super.getAllModifiableVariableHolders();
        if (this.ticket != null) {
            holders.add(this.ticket);
        }
        return holders;
    }

    @Override
    public NewSessionTicketHandler getHandler(Context context) {
        return new NewSessionTicketHandler(context.getTlsContext());
    }

    @Override
    public NewSessionTicketParser getParser(Context context, InputStream stream) {
        return new NewSessionTicketParser(stream, context.getTlsContext());
    }

    @Override
    public NewSessionTicketPreparator getPreparator(Context context) {
        return new NewSessionTicketPreparator(context.getChooser(), this);
    }

    @Override
    public NewSessionTicketSerializer getSerializer(Context context) {
        return new NewSessionTicketSerializer(this, context.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public String toShortString() {
        return "ST";
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.ticketLifetimeHint);
        hash = 53 * hash + Objects.hashCode((Object)this.ticket);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NewSessionTicketMessage other = (NewSessionTicketMessage)obj;
        if (!Objects.equals(this.ticketLifetimeHint, other.ticketLifetimeHint)) {
            return false;
        }
        return Objects.equals((Object)this.ticket, (Object)other.ticket);
    }
}

