/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.FinishedHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.FinishedParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.FinishedPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.FinishedSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.Objects;

@XmlRootElement(name="Finished")
public class FinishedMessage
extends HandshakeMessage {
    @ModifiableVariableProperty
    private ModifiableByteArray verifyData;

    public FinishedMessage() {
        super(HandshakeMessageType.FINISHED);
    }

    public ModifiableByteArray getVerifyData() {
        return this.verifyData;
    }

    public void setVerifyData(ModifiableByteArray verifyData) {
        this.verifyData = verifyData;
    }

    public void setVerifyData(byte[] value) {
        this.verifyData = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.verifyData, (byte[])value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FinishedMessage:");
        sb.append("\n  Verify Data: ");
        if (this.verifyData != null && this.verifyData.getOriginalValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.verifyData.getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "FIN";
    }

    @Override
    public FinishedHandler getHandler(Context context) {
        return new FinishedHandler(context.getTlsContext());
    }

    @Override
    public FinishedParser getParser(Context context, InputStream stream) {
        return new FinishedParser(stream, context.getTlsContext());
    }

    @Override
    public FinishedPreparator getPreparator(Context context) {
        return new FinishedPreparator(context.getChooser(), this);
    }

    @Override
    public FinishedSerializer getSerializer(Context context) {
        return new FinishedSerializer(this);
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.verifyData);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FinishedMessage other = (FinishedMessage)obj;
        return Objects.equals(this.verifyData, other.verifyData);
    }
}

