/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.EchClientHelloType;
import de.rub.nds.tlsattacker.core.protocol.handler.ClientHelloHandler;
import de.rub.nds.tlsattacker.core.protocol.message.CoreClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptedClientHelloExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ClientHelloParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.ClientHelloPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.ClientHelloSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;

@XmlRootElement(name="ClientHello")
public class ClientHelloMessage
extends CoreClientHelloMessage {
    public ClientHelloMessage() {
    }

    public ClientHelloMessage(Config tlsConfig) {
        super(tlsConfig);
        if (tlsConfig.isAddEncryptedClientHelloExtension().booleanValue()) {
            this.addExtension(new EncryptedClientHelloExtensionMessage(EchClientHelloType.INNER));
        }
    }

    @Override
    public ClientHelloHandler getHandler(Context context) {
        return new ClientHelloHandler(context.getTlsContext());
    }

    @Override
    public ClientHelloParser getParser(Context context, InputStream stream) {
        return new ClientHelloParser(stream, context.getTlsContext());
    }

    @Override
    public ClientHelloPreparator getPreparator(Context context) {
        return new ClientHelloPreparator(context.getChooser(), this);
    }

    @Override
    public ClientHelloSerializer getSerializer(Context context) {
        return new ClientHelloSerializer(this, context.getChooser().getSelectedProtocolVersion());
    }
}

