/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SignedCertificateTimestampExtensionMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignedCertificateTimestampExtensionHandler
extends ExtensionHandler<SignedCertificateTimestampExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SignedCertificateTimestampExtensionHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustTLSExtensionContext(SignedCertificateTimestampExtensionMessage message) {
        if ((Integer)message.getExtensionLength().getValue() > 65535) {
            LOGGER.warn("The SingedCertificateTimestamp length shouldn't exceed 2 bytes as defined in RFC 6962. Length was " + String.valueOf(message.getExtensionLength().getValue()));
        }
        this.tlsContext.setSignedCertificateTimestamp((byte[])message.getSignedTimestamp().getValue());
        LOGGER.debug("The context SignedCertificateTimestamp was set to {}", (Object)message.getSignedTimestamp());
    }
}

