/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.RenegotiationInfoExtensionMessage;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RenegotiationInfoExtensionHandler
extends ExtensionHandler<RenegotiationInfoExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public RenegotiationInfoExtensionHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustTLSExtensionContext(RenegotiationInfoExtensionMessage message) {
        if ((Integer)message.getExtensionLength().getValue() > 65535) {
            LOGGER.warn("The RenegotiationInfo length shouldn't exceed 2 bytes as defined in RFC 5246. Length was " + String.valueOf(message.getExtensionLength().getValue()));
        }
        if (this.tlsContext.getTalkingConnectionEndType() != this.tlsContext.getChooser().getConnectionEndType()) {
            this.tlsContext.setRenegotiationInfo((byte[])message.getRenegotiationInfo().getValue());
            LOGGER.debug("The context RenegotiationInfo was set to {}", (Object)message.getRenegotiationInfo());
        }
        if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.SERVER && ((byte[])message.getRenegotiationInfo().getValue()).length == 1 && ((byte[])message.getRenegotiationInfo().getValue())[0] == 0) {
            this.tlsContext.setSecureRenegotiation(true);
        }
    }
}

