/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.constants.CertificateType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientCertificateTypeExtensionMessage;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientCertificateTypeExtensionHandler
extends ExtensionHandler<ClientCertificateTypeExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ClientCertificateTypeExtensionHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustTLSExtensionContext(ClientCertificateTypeExtensionMessage message) {
        if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.SERVER) {
            if (((byte[])message.getCertificateTypes().getValue()).length != 1) {
                LOGGER.warn("Invalid ClientCertificateType extension. Not adjusting context");
            } else {
                this.tlsContext.setSelectedClientCertificateType(CertificateType.getCertificateType(((byte[])message.getCertificateTypes().getValue())[0]));
            }
        } else if (message.getCertificateTypes() != null) {
            this.tlsContext.setClientCertificateTypeDesiredTypes(CertificateType.getCertificateTypesAsList((byte[])message.getCertificateTypes().getValue()));
        } else {
            LOGGER.warn("Null CertificateTypes - not adjusting");
        }
    }
}

