/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ServerKeyExchangeHandler<MessageT extends ServerKeyExchangeMessage>
extends HandshakeMessageHandler<MessageT> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    protected void adjustSelectedSignatureAndHashAlgorithm(MessageT message) {
        if (((ServerKeyExchangeMessage)message).getSignatureAndHashAlgorithm() != null && ((ServerKeyExchangeMessage)message).getSignatureAndHashAlgorithm().getValue() != null) {
            byte[] sigHashBytes = (byte[])((ServerKeyExchangeMessage)message).getSignatureAndHashAlgorithm().getValue();
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = SignatureAndHashAlgorithm.getSignatureAndHashAlgorithm(sigHashBytes);
            this.tlsContext.setSelectedSignatureAndHashAlgorithm(signatureAndHashAlgorithm);
        }
    }
}

