/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.SSL2MessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerHelloMessage;
import de.rub.nds.x509attacker.filesystem.CertificateIo;
import de.rub.nds.x509attacker.x509.X509CertificateChain;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSL2ServerHelloHandler
extends SSL2MessageHandler<SSL2ServerHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SSL2ServerHelloHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    private X509CertificateChain parseCertificate(int lengthBytes, byte[] bytesToParse) {
        LOGGER.debug("SSL2 lengthBytes: {}", (Object)lengthBytes);
        LOGGER.debug("SSL2 bytesToParse: {}", (Object)bytesToParse);
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(bytesToParse);
            return CertificateIo.readRawCertificateAsChain((InputStream)stream);
        }
        catch (IOException | IllegalArgumentException e) {
            LOGGER.warn("Could not parse Certificate bytes into Certificate object:\n{}", (Object)bytesToParse);
            LOGGER.debug((Object)e);
            return null;
        }
    }

    @Override
    public void adjustContext(SSL2ServerHelloMessage message) {
        byte[] serverRandom = (byte[])message.getSessionId().getValue();
        if (serverRandom != null) {
            this.tlsContext.setServerRandom(serverRandom);
        }
        X509CertificateChain certificateChain = this.parseCertificate((Integer)message.getCertificateLength().getValue(), (byte[])message.getCertificate().getValue());
        LOGGER.debug("Setting ServerCertificate in Context");
        this.tlsContext.setServerCertificateChain(certificateChain);
    }
}

