/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.protocol.constants.GroupParameters;
import de.rub.nds.protocol.constants.NamedEllipticCurveParameters;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.crypto.ec.PointFormatter;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.ServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHEServerKeyExchangeMessage;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ECDHEServerKeyExchangeHandler<KeyExchangeMessage extends ECDHEServerKeyExchangeMessage>
extends ServerKeyExchangeHandler<KeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ECDHEServerKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(KeyExchangeMessage message) {
        this.adjustECParameter((ECDHEServerKeyExchangeMessage)message);
        this.adjustSelectedSignatureAndHashAlgorithm(message);
        if (((ECDHEServerKeyExchangeMessage)message).getKeyExchangeComputations() != null) {
            this.tlsContext.setServerEphemeralEcPrivateKey((BigInteger)((ECDHEServerKeyExchangeMessage)message).getKeyExchangeComputations().getPrivateKey().getValue());
        }
    }

    protected void adjustECParameter(ECDHEServerKeyExchangeMessage message) {
        NamedGroup group = NamedGroup.getNamedGroup((byte[])message.getNamedGroup().getValue());
        if (group != null) {
            Point publicKeyPoint;
            LOGGER.debug("Adjusting selected named group: {}", (Object)group.name());
            this.tlsContext.setSelectedGroup(group);
            LOGGER.debug("Adjusting EC Point");
            if (group.getGroupParameters() == null || !(group.getGroupParameters() instanceof NamedEllipticCurveParameters)) {
                LOGGER.debug("Unsuited group parameters for EC point adjustment. Falling back to SECP256R1.");
                publicKeyPoint = PointFormatter.formatFromByteArray((GroupParameters)((NamedEllipticCurveParameters)NamedGroup.SECP256R1.getGroupParameters()), (byte[])((byte[])message.getPublicKey().getValue()));
            } else {
                publicKeyPoint = PointFormatter.formatFromByteArray((GroupParameters)((NamedEllipticCurveParameters)group.getGroupParameters()), (byte[])((byte[])message.getPublicKey().getValue()));
            }
            this.tlsContext.setServerEphemeralEcPublicKey(publicKeyPoint);
        } else {
            LOGGER.warn("Could not adjust server public key, named group is unknown.");
        }
    }
}

