/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.dtls.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.Handler;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ProtocolMessageHandler<MessageT extends ProtocolMessage>
extends Handler<MessageT> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final TlsContext tlsContext;

    public ProtocolMessageHandler(TlsContext tlsContext) {
        this.tlsContext = tlsContext;
    }

    public void updateDigest(ProtocolMessage message, boolean goingToBeSent) {
        if (!(message instanceof HandshakeMessage)) {
            return;
        }
        HandshakeMessage handshakeMessage = (HandshakeMessage)message;
        if (!handshakeMessage.getIncludeInDigest()) {
            return;
        }
        ProtocolVersion version = this.tlsContext.getChooser().getSelectedProtocolVersion();
        if (version == ProtocolVersion.DTLS10 || version == ProtocolVersion.DTLS12) {
            DtlsHandshakeMessageFragment fragment = this.tlsContext.getDtlsFragmentLayer().wrapInSingleFragment(this.tlsContext.getContext(), handshakeMessage, goingToBeSent);
            this.tlsContext.getDigest().append((byte[])fragment.getCompleteResultingMessage().getValue());
        } else {
            this.tlsContext.getDigest().append((byte[])message.getCompleteResultingMessage().getValue());
        }
        LOGGER.debug("Included in digest: {}", (Object)message.toCompactString());
    }

    public void adjustContextAfterSerialize(MessageT message) {
    }

    public void adjustContextBeforeParse(MessageT message) {
    }

    public void adjustContextAfterParse(MessageT message) {
    }

    public void adjustContextAfterPrepare(MessageT message) {
    }

    public void adjustContextBeforePrepare(MessageT message) {
    }
}

