/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer.stream;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.exception.EndOfStreamException;
import de.rub.nds.protocol.exception.ParserException;
import de.rub.nds.tlsattacker.core.layer.hints.LayerProcessingHint;
import java.io.IOException;
import java.io.InputStream;

public abstract class HintedInputStream
extends InputStream {
    private LayerProcessingHint hint;

    public HintedInputStream(LayerProcessingHint hint) {
        this.hint = hint;
    }

    public LayerProcessingHint getHint() {
        return this.hint;
    }

    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    public int readInt(int size) throws IOException {
        if (size < 0 || size > 4) {
            throw new ParserException("Cannot read Integer of size " + size);
        }
        byte[] readChunk = this.readChunk(size);
        return DataConverter.bytesToInt((byte[])readChunk);
    }

    public byte[] readChunk(int size) throws IOException {
        if (size == 0) {
            return new byte[0];
        }
        byte[] chunk = new byte[size];
        int read = this.read(chunk);
        if (read != size) {
            throw new EndOfStreamException("Could not read " + size + " bytes from the stream. Only " + read + " bytes available");
        }
        return chunk;
    }

    protected abstract InputStream getDataSource();

    public abstract void extendStream(byte[] var1);

    public void setHint(LayerProcessingHint hint) {
        this.hint = hint;
    }
}

