/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer.data;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.exception.EndOfStreamException;
import de.rub.nds.protocol.exception.ParserException;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Parser<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final InputStream stream;
    protected SilentByteArrayOutputStream quicBuffer = new SilentByteArrayOutputStream();
    private final SilentByteArrayOutputStream outputStream;

    protected Parser(InputStream stream) {
        this.stream = stream;
        this.outputStream = new SilentByteArrayOutputStream();
    }

    public byte[] getAlreadyParsed() {
        return this.outputStream.toByteArray();
    }

    protected byte[] parseByteArrayField(int length) {
        if (length == 0) {
            return new byte[0];
        }
        if (length < 0) {
            throw new ParserException("Trying to parse a negative amount of bytes");
        }
        byte[] data = new byte[length];
        try {
            int read = this.stream.read(data);
            if (read == -1) {
                throw new EndOfStreamException("Reached end of Stream");
            }
            if (read != length) {
                throw new EndOfStreamException("Reached end of stream after " + read + " bytes");
            }
            this.outputStream.write(data);
        }
        catch (IOException E) {
            throw new ParserException("Could not parse byteArrayField of length=" + length, (Throwable)E);
        }
        return data;
    }

    protected int parseIntField(int length) {
        if (length == 0) {
            throw new ParserException("Cannot parse int of size 0");
        }
        return DataConverter.bytesToInt((byte[])this.parseByteArrayField(length));
    }

    protected BigInteger parseBigIntField(int length) {
        if (length == 0) {
            throw new ParserException("Cannot parse BigInt of size 0");
        }
        return new BigInteger(1, this.parseByteArrayField(length));
    }

    protected byte parseByteField(int length) {
        if (length == 0) {
            throw new ParserException("Cannot parse byte of size 0");
        }
        if (length > 1) {
            LOGGER.warn("Parsing byte[] field into a byte of size >1");
        }
        return (byte)DataConverter.bytesToInt((byte[])this.parseByteArrayField(length));
    }

    protected String parseStringTill(byte endSequence) {
        byte b;
        SilentByteArrayOutputStream tempStream = new SilentByteArrayOutputStream();
        do {
            b = this.parseByteField(1);
            tempStream.write((int)b);
        } while (b != endSequence);
        return tempStream.toString(StandardCharsets.US_ASCII);
    }

    protected boolean enoughBytesLeft(int count) {
        return this.getBytesLeft() >= count;
    }

    protected byte[] parseArrayOrTillEnd(int n) {
        if (n >= 0 && n < this.getBytesLeft()) {
            return this.parseByteArrayField(n);
        }
        return this.parseByteArrayField(this.getBytesLeft());
    }

    protected byte[] parseTillEnd() {
        return this.parseByteArrayField(this.getBytesLeft());
    }

    public int getBytesLeft() {
        try {
            return this.stream.available();
        }
        catch (IOException ex) {
            throw new ParserException("Cannot tell how many bytes are left in inputstream", (Throwable)ex);
        }
    }

    public abstract void parse(T var1);

    protected InputStream getStream() {
        return this.stream;
    }

    protected long parseVariableLengthInteger() {
        byte b = this.parseByteField(1);
        this.quicBuffer.write((int)b);
        long v = b;
        byte prefix = (byte)((v & 0xFFL) >> 6);
        byte length = (byte)(1 << prefix);
        v = (byte)v & 0x3F;
        for (int i = 0; i < length - 1; ++i) {
            b = this.parseByteField(1);
            this.quicBuffer.write((int)b);
            v = (v << 8) + (long)(b & 0xFF);
        }
        return v;
    }
}

