/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.dtls.parser;

import de.rub.nds.tlsattacker.core.dtls.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.layer.data.Parser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DtlsHandshakeMessageFragmentParser
extends Parser<DtlsHandshakeMessageFragment> {
    private static final Logger LOGGER = LogManager.getLogger();

    public DtlsHandshakeMessageFragmentParser(InputStream stream) {
        super(stream);
    }

    @Override
    public void parse(DtlsHandshakeMessageFragment msg) {
        this.parseType(msg);
        this.parseLength(msg);
        this.parseMessageSequence(msg);
        this.parseFragmentOffset(msg);
        this.parseFragmentLength(msg);
        msg.setFragmentContent(this.parseByteArrayField((Integer)msg.getFragmentLength().getValue()));
    }

    private void parseType(DtlsHandshakeMessageFragment msg) {
        msg.setType(this.parseByteField(1));
        LOGGER.debug("Type: {}", msg.getType().getValue());
    }

    private void parseLength(DtlsHandshakeMessageFragment msg) {
        msg.setLength(this.parseIntField(3));
        LOGGER.debug("Length: {}", msg.getLength().getValue());
    }

    private void parseFragmentOffset(DtlsHandshakeMessageFragment msg) {
        msg.setFragmentOffset(this.parseIntField(3));
        LOGGER.debug("FragmentOffset: {}", msg.getFragmentOffset().getValue());
    }

    private void parseFragmentLength(DtlsHandshakeMessageFragment msg) {
        msg.setFragmentLength(this.parseIntField(3));
        LOGGER.debug("FragmentLength: {}", msg.getFragmentLength().getValue());
    }

    private void parseMessageSequence(DtlsHandshakeMessageFragment msg) {
        msg.setMessageSequence(this.parseIntField(2));
        LOGGER.debug("MessageSequence: {}", msg.getMessageSequence().getValue());
    }
}

