/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.hpke;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.constants.hpke.HpkeAeadFunction;

public abstract class HpkeContext {
    protected final byte[] aeadKey;
    protected final byte[] baseNonce;
    protected final byte[] exporterSecret;
    protected final HpkeAeadFunction hpkeAeadFunction;
    protected int sequenceNumber;

    public HpkeContext(byte[] aeadKey, byte[] baseNonce, int sequenceNumber, byte[] exporterSecret, HpkeAeadFunction hpkeAeadFunction) {
        this.aeadKey = aeadKey;
        this.baseNonce = baseNonce;
        this.exporterSecret = exporterSecret;
        this.sequenceNumber = sequenceNumber;
        this.hpkeAeadFunction = hpkeAeadFunction;
    }

    protected byte[] computeNonce() {
        byte[] sequenceBytes = DataConverter.intToBytes((int)this.sequenceNumber, (int)this.hpkeAeadFunction.getNonceLength());
        byte[] nonce = new byte[sequenceBytes.length];
        for (int i = 0; i < sequenceBytes.length; ++i) {
            nonce[i] = (byte)(sequenceBytes[i] ^ this.baseNonce[i]);
        }
        return nonce;
    }

    protected void incrementSequenceNumber() throws CryptoException {
        if (Integer.bitCount(this.sequenceNumber) >= 8 * this.hpkeAeadFunction.getNonceLength()) {
            throw new CryptoException("Message limit reached");
        }
    }
}

