/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.cipher;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.crypto.cipher.BaseCipher;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.ChaCha20ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.Salsa20Engine;
import org.bouncycastle.crypto.macs.Poly1305;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;

public abstract class ChaCha20Poly1305Cipher
extends BaseCipher {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int TAG_LENGTH = 16;
    private static final byte[] ZEROES = new byte[15];
    private final byte[] key;
    private boolean draftStructure;
    private Salsa20Engine cipher;
    private final Poly1305 mac = new Poly1305();
    protected final int IV_LENGTH;

    public ChaCha20Poly1305Cipher(byte[] key, int ivLength) {
        if (key.length != 32) {
            LOGGER.warn("Key for ChaCha20Poly1305 has wrong size. Expected 32 byte but found: {}. Padding/Trimming to 32 Byte.", (Object)key.length);
            if (key.length > 32) {
                key = Arrays.copyOfRange((byte[])key, (int)0, (int)32);
            } else {
                byte[] tempKey = new byte[32];
                for (int i = 0; i < key.length; ++i) {
                    tempKey[i] = key[i];
                }
                key = tempKey;
            }
        }
        this.key = key;
        this.IV_LENGTH = ivLength;
    }

    @Override
    public byte[] decrypt(byte[] someBytes) throws CryptoException {
        throw new UnsupportedOperationException("ChaCha20Poly1305 can only be used as an AEAD Cipher!");
    }

    @Override
    public byte[] decrypt(byte[] iv, byte[] someBytes) {
        throw new UnsupportedOperationException("ChaCha20Poly1305 can only be used as an AEAD Cipher!");
    }

    @Override
    public byte[] decrypt(byte[] iv, int tagLength, byte[] someBytes) {
        throw new UnsupportedOperationException("ChaCha20Poly1305 can only be used as an AEAD Cipher!");
    }

    @Override
    public byte[] decrypt(byte[] iv, int tagLength, byte[] additionalAuthenticatedData, byte[] ciphertext) throws CryptoException {
        this.cipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.key, 0, this.key.length), new byte[tagLength / 8 - 1], 0, iv.length));
        int additionalDataLength = additionalAuthenticatedData.length;
        int ciphertextLength = ciphertext.length - tagLength / 8;
        byte[] plaintext = new byte[this.getOutputSize(false, ciphertext.length)];
        byte[] aadLengthLittleEndian = DataConverter.reverseByteOrder((byte[])DataConverter.longToBytes((long)additionalDataLength, (int)8));
        byte[] ciphertextLengthLittleEndian = DataConverter.reverseByteOrder((byte[])DataConverter.longToBytes((long)ciphertextLength, (int)8));
        this.cipher.init(false, (CipherParameters)new ParametersWithIV(null, iv));
        this.initMAC();
        byte[] calculatedMAC = new byte[16];
        if (this.draftStructure) {
            byte[] macInput = DataConverter.concatenate((byte[][])new byte[][]{additionalAuthenticatedData, aadLengthLittleEndian});
            macInput = DataConverter.concatenate((byte[])macInput, (byte[])ciphertext, (int)ciphertextLength);
            macInput = DataConverter.concatenate((byte[][])new byte[][]{macInput, ciphertextLengthLittleEndian});
            this.mac.update(macInput, 0, macInput.length);
            this.mac.doFinal(calculatedMAC, 0);
        } else {
            this.updateMAC(additionalAuthenticatedData, 0, additionalDataLength);
            this.updateMAC(ciphertext, 0, ciphertextLength);
            calculatedMAC = DataConverter.concatenate((byte[])aadLengthLittleEndian, (byte[])ciphertextLengthLittleEndian, (int)8);
            this.mac.update(calculatedMAC, 0, tagLength / 8);
            this.mac.doFinal(calculatedMAC, 0);
        }
        byte[] receivedMAC = Arrays.copyOfRange((byte[])ciphertext, (int)ciphertextLength, (int)ciphertext.length);
        if (!Arrays.areEqual((byte[])calculatedMAC, (byte[])receivedMAC)) {
            LOGGER.warn("MAC verification failed");
            throw new CryptoException();
        }
        this.cipher.processBytes(ciphertext, 0, ciphertextLength, plaintext, 0);
        return plaintext;
    }

    @Override
    public byte[] encrypt(byte[] iv, int tagLength, byte[] additionAuthenticatedData, byte[] someBytes) {
        if (iv.length != this.IV_LENGTH) {
            LOGGER.warn("IV for ChaCha20Poly1305 has wrong size. Expected {} byte but found: {}. Padding/Trimming to {} Byte.", (Object)this.IV_LENGTH, (Object)iv.length, (Object)this.IV_LENGTH);
            if (iv.length > this.IV_LENGTH) {
                iv = Arrays.copyOfRange((byte[])iv, (int)0, (int)this.IV_LENGTH);
            } else {
                byte[] tempIv = new byte[this.IV_LENGTH];
                for (int i = 0; i < iv.length; ++i) {
                    tempIv[i] = iv[i];
                }
                iv = tempIv;
            }
        }
        this.cipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.key, 0, this.key.length), new byte[tagLength / 8 - 1], 0, iv.length));
        int additionalDataLength = additionAuthenticatedData.length;
        int plaintextLength = someBytes.length;
        byte[] ciphertext = new byte[this.getOutputSize(true, plaintextLength)];
        this.cipher.init(true, (CipherParameters)new ParametersWithIV(null, iv));
        this.initMAC();
        this.cipher.processBytes(someBytes, 0, plaintextLength, ciphertext, 0);
        byte[] aadLengthLittleEndian = DataConverter.reverseByteOrder((byte[])DataConverter.longToBytes((long)additionalDataLength, (int)8));
        byte[] plaintextLengthLittleEndian = DataConverter.reverseByteOrder((byte[])DataConverter.longToBytes((long)plaintextLength, (int)8));
        byte[] aadPlaintextLengthsLittleEndian = DataConverter.concatenate((byte[])aadLengthLittleEndian, (byte[])plaintextLengthLittleEndian, (int)8);
        if (this.draftStructure) {
            byte[] macInput = DataConverter.concatenate((byte[][])new byte[][]{additionAuthenticatedData, aadLengthLittleEndian});
            macInput = DataConverter.concatenate((byte[])macInput, (byte[])ciphertext, (int)plaintextLength);
            macInput = DataConverter.concatenate((byte[][])new byte[][]{macInput, plaintextLengthLittleEndian});
            this.mac.update(macInput, 0, macInput.length);
            this.mac.doFinal(ciphertext, 0 + plaintextLength);
        } else {
            this.updateMAC(additionAuthenticatedData, 0, additionalDataLength);
            this.updateMAC(ciphertext, 0, plaintextLength);
            this.mac.update(aadPlaintextLengthsLittleEndian, 0, tagLength / 8);
            this.mac.doFinal(ciphertext, 0 + plaintextLength);
        }
        return ciphertext;
    }

    @Override
    public byte[] encrypt(byte[] someBytes) throws CryptoException {
        throw new UnsupportedOperationException("ChaCha20Poly1305 can only be used as an AEAD Cipher!");
    }

    @Override
    public byte[] encrypt(byte[] iv, byte[] someBytes) {
        throw new UnsupportedOperationException("ChaCha20Poly1305 can only be used as an AEAD Cipher!");
    }

    @Override
    public byte[] encrypt(byte[] iv, int tagLength, byte[] someBytes) {
        throw new UnsupportedOperationException("ChaCha20Poly1305 can only be used as an AEAD Cipher!");
    }

    @Override
    public int getBlocksize() {
        throw new UnsupportedOperationException("ChaCha20Poly1305 can only be used as an AEAD Cipher!");
    }

    @Override
    public byte[] getIv() {
        throw new UnsupportedOperationException();
    }

    private int getOutputSize(boolean isEncrypting, int inputLength) {
        return isEncrypting ? inputLength + 16 : inputLength - 16;
    }

    private void initMAC() {
        byte[] firstBlock = new byte[64];
        this.cipher.processBytes(firstBlock, 0, 64, firstBlock, 0);
        this.mac.init((CipherParameters)new KeyParameter(firstBlock, 0, 32));
    }

    @Override
    public void setIv(byte[] iv) {
        throw new UnsupportedOperationException("The IV has to be passed with the encrypt() call!");
    }

    private void updateMAC(byte[] buf, int off, int len) {
        this.mac.update(buf, off, len);
        int partial = len % 16;
        if (partial != 0) {
            this.mac.update(ZEROES, 0, 16 - partial);
        }
    }

    public void setCipher(Salsa20Engine cipher) {
        this.cipher = cipher;
    }

    public boolean isDraftStructure() {
        return this.draftStructure;
    }

    public void setDraftStructure(boolean draftStructure) {
        this.draftStructure = draftStructure;
    }

    @Override
    public byte[] getDtls13Mask(byte[] key, byte[] ciphertext) throws CryptoException {
        if (ciphertext.length < 16) {
            LOGGER.warn("The ciphertext is too short. Padding it to the required length with zero bytes.");
        }
        byte[] tempCiphertext = Arrays.copyOf((byte[])ciphertext, (int)16);
        try {
            Cipher recordNumberCipher = Cipher.getInstance("ChaCha20");
            byte[] counter = Arrays.copyOfRange((byte[])tempCiphertext, (int)0, (int)4);
            byte[] nonce = Arrays.copyOfRange((byte[])tempCiphertext, (int)4, (int)12);
            ChaCha20ParameterSpec parameterSpec = new ChaCha20ParameterSpec(nonce, new BigInteger(counter).intValue());
            SecretKeySpec keySpec = new SecretKeySpec(key, "ChaCha20");
            recordNumberCipher.init(1, (Key)keySpec, parameterSpec);
            byte[] toEncrypt = new byte[64];
            return recordNumberCipher.doFinal(toEncrypt);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Error getting record number mask using ChaCha20: ", (Throwable)ex);
        }
    }
}

