/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.constants.MacAlgorithm;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.constants.PRFAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.HMAC;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PseudoRandomFunction {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MASTER_SECRET_LABEL = "master secret";
    public static final String CLIENT_FINISHED_LABEL = "client finished";
    public static final String SERVER_FINISHED_LABEL = "server finished";
    public static final String KEY_EXPANSION_LABEL = "key expansion";
    public static final String EXTENDED_MASTER_SECRET_LABEL = "extended master secret";
    public static final String CLIENT_WRITE_KEY_LABEL = "client write key";
    public static final String SERVER_WRITE_KEY_LABEL = "server write key";
    public static final String IV_BLOCK_LABEL = "IV block";
    private static final byte sByte = 65;

    public static byte[] computeSSL3(byte[] master_secret, byte[] client_random, byte[] server_random, int size) throws NoSuchAlgorithmException, IOException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        try (SilentByteArrayOutputStream pseudoRandomBitStream = new SilentByteArrayOutputStream();){
            int i = 0;
            while (pseudoRandomBitStream.size() <= size) {
                try (SilentByteArrayOutputStream outputMd5 = new SilentByteArrayOutputStream();
                     SilentByteArrayOutputStream outputSha = new SilentByteArrayOutputStream();
                     SilentByteArrayOutputStream salt = new SilentByteArrayOutputStream();){
                    for (int j = 0; j <= i; ++j) {
                        salt.write(65 + i);
                    }
                    outputSha.write(sha1.digest(DataConverter.concatenate((byte[][])new byte[][]{salt.toByteArray(), master_secret, server_random, client_random})));
                    outputMd5.write(md5.digest(DataConverter.concatenate((byte[][])new byte[][]{master_secret, outputSha.toByteArray()})));
                    pseudoRandomBitStream.write(outputMd5.toByteArray());
                }
                ++i;
            }
            byte[] byArray = Arrays.copyOf(pseudoRandomBitStream.toByteArray(), size);
            return byArray;
        }
    }

    public static byte[] compute(PRFAlgorithm prfAlgorithm, byte[] secret, String label, byte[] seed, int size) throws CryptoException {
        if (prfAlgorithm == null) {
            LOGGER.warn("Trying to compute PRF without specified PRF algorithm. Using TLS 1.0/TLS 1.1 as default.");
            prfAlgorithm = PRFAlgorithm.TLS_PRF_LEGACY;
        }
        if (secret == null) {
            LOGGER.warn("Secret is null! Continuing to compute PRF with a secret set to zero bytes...");
            secret = new byte[]{};
        }
        if (prfAlgorithm == PRFAlgorithm.TLS_PRF_LEGACY) {
            return PseudoRandomFunction.computeTls10(secret, label, seed, size);
        }
        switch (prfAlgorithm) {
            case TLS_PRF_SHA256: {
                return PseudoRandomFunction.computeTls12(secret, label, seed, size, MacAlgorithm.HMAC_SHA256);
            }
            case TLS_PRF_SHA384: {
                return PseudoRandomFunction.computeTls12(secret, label, seed, size, MacAlgorithm.HMAC_SHA384);
            }
            case TLS_PRF_GOSTR3411: {
                return PseudoRandomFunction.computeTls12(secret, label, seed, size, MacAlgorithm.HMAC_GOSTR3411);
            }
            case TLS_PRF_GOSTR3411_2012_256: {
                return PseudoRandomFunction.computeTls12(secret, label, seed, size, MacAlgorithm.HMAC_GOSTR3411_2012_256);
            }
        }
        throw new UnsupportedOperationException("PRF computation for different protocol versions is not supported yet");
    }

    private static byte[] computeTls10(byte[] secret, String label, byte[] seed, int size) throws CryptoException {
        try {
            byte[] labelSeed = DataConverter.concatenate((byte[][])new byte[][]{label.getBytes(Charset.forName("ASCII")), seed});
            byte[] pseudoRandomBitStream = new byte[size];
            HMAC hmacMd5 = new HMAC(MacAlgorithm.HMAC_MD5);
            HMAC hmacSha1 = new HMAC(MacAlgorithm.HMAC_SHA1);
            int secretHalf = (secret.length + 1) / 2;
            byte[] s1 = new byte[secretHalf];
            byte[] s2 = new byte[secretHalf];
            System.arraycopy(secret, 0, s1, 0, secretHalf);
            System.arraycopy(secret, secret.length - secretHalf, s2, 0, secretHalf);
            hmacMd5.init(s1);
            hmacSha1.init(s2);
            byte[] extendedSecretMd5 = PseudoRandomFunction.p_hash(hmacMd5, labelSeed, size);
            byte[] extendedSecretSha1 = PseudoRandomFunction.p_hash(hmacSha1, labelSeed, size);
            for (int i = 0; i < size; ++i) {
                pseudoRandomBitStream[i] = (byte)(extendedSecretMd5[i] ^ extendedSecretSha1[i]);
            }
            return pseudoRandomBitStream;
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            throw new CryptoException((Throwable)ex);
        }
    }

    private static byte[] computeTls12(byte[] secret, String label, byte[] seed, int size, MacAlgorithm macAlgorithm) throws CryptoException {
        try {
            byte[] labelSeed = DataConverter.concatenate((byte[][])new byte[][]{label.getBytes(Charset.forName("ASCII")), seed});
            HMAC hmac = new HMAC(macAlgorithm);
            hmac.init(secret);
            byte[] pseudoRandomBitStream = PseudoRandomFunction.p_hash(hmac, labelSeed, size);
            return pseudoRandomBitStream;
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            throw new CryptoException((Throwable)ex);
        }
    }

    private static byte[] p_hash(HMAC hmac, byte[] data, int size) throws NoSuchAlgorithmException, IOException {
        try (SilentByteArrayOutputStream extendedSecret = new SilentByteArrayOutputStream();){
            byte[] hmacIteration = data;
            while (extendedSecret.size() < size) {
                hmacIteration = hmac.doFinal(hmacIteration);
                extendedSecret.write(hmac.doFinal(DataConverter.concatenate((byte[][])new byte[][]{hmacIteration, data})));
            }
            byte[] byArray = Arrays.copyOf(extendedSecret.toByteArray(), size);
            return byArray;
        }
    }

    private PseudoRandomFunction() {
    }
}

