/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.DigestAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageDigestCollector {
    private static final Logger LOGGER = LogManager.getLogger();
    private SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();

    public void append(byte[] bytes) {
        this.stream.write(bytes);
    }

    public byte[] digest(ProtocolVersion version, CipherSuite suite) {
        try {
            MessageDigest hash1;
            MessageDigest hash2 = null;
            DigestAlgorithm algorithm = AlgorithmResolver.getDigestAlgorithm(version, suite);
            if (null == algorithm) {
                LOGGER.warn("null algorithm for version {} and suite {}. Using SHA256", (Object)version, (Object)suite);
                hash1 = MessageDigest.getInstance(DigestAlgorithm.SHA256.getJavaName());
            } else {
                switch (algorithm) {
                    case SSL_DIGEST: {
                        throw new RuntimeException("Unsupported DigestAlgorithm SSL_DIGEST");
                    }
                    case LEGACY: {
                        hash1 = MessageDigest.getInstance("MD5");
                        hash2 = MessageDigest.getInstance("SHA-1");
                        break;
                    }
                    default: {
                        hash1 = MessageDigest.getInstance(algorithm.getJavaName());
                    }
                }
            }
            hash1.update(this.stream.toByteArray());
            byte[] digest = hash1.digest();
            if (hash2 != null) {
                hash2.update(this.stream.toByteArray());
                byte[] d2 = hash2.digest();
                digest = DataConverter.concatenate((byte[][])new byte[][]{digest, d2});
            }
            return digest;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException("Unsupported Hash algorithm!");
        }
    }

    public void reset() {
        this.stream = new SilentByteArrayOutputStream();
    }

    public byte[] getRawBytes() {
        return this.stream.toByteArray();
    }

    public void setRawBytes(byte[] rawBytes) {
        this.reset();
        if (rawBytes != null) {
            this.stream.write(rawBytes);
        }
    }
}

