/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public enum EchConfigVersion {
    DRAFT_FF03(new byte[]{-2, 3}),
    DRAFT_FF07(new byte[]{-2, 7}),
    DRAFT_FF08(new byte[]{-2, 8}),
    DRAFT_FF09(new byte[]{-2, 9}),
    DRAFT_FF0A(new byte[]{-2, 10}),
    DRAFT_FF0B(new byte[]{-2, 11}),
    DRAFT_FF0C(new byte[]{-2, 12}),
    DRAFT_FF0D(new byte[]{-2, 13});

    private static final Map<BigInteger, EchConfigVersion> MAP;
    private final byte[] byteValue;

    private EchConfigVersion(byte[] byteValue) {
        this.byteValue = byteValue;
    }

    public byte[] getByteValue() {
        return this.byteValue;
    }

    public static EchConfigVersion getEnumByByte(byte[] versionBytes) {
        BigInteger hashMapKey = new BigInteger(versionBytes);
        return MAP.get(hashMapKey);
    }

    static {
        MAP = new HashMap<BigInteger, EchConfigVersion>();
        for (EchConfigVersion version : EchConfigVersion.values()) {
            byte[] versionBytes = version.getByteValue();
            if (versionBytes == null) continue;
            BigInteger hashMapKey = new BigInteger(versionBytes);
            MAP.put(hashMapKey, version);
        }
    }
}

