/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config.delegate;

import com.beust.jcommander.Parameter;
import de.rub.nds.protocol.exception.ConfigurationException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.Delegate;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import java.util.Collections;
import java.util.List;

public class SignatureAlgorithmCertDelegate
extends Delegate {
    @Parameter(names={"-signature_algo_cert"}, description="Supported Signature and Hash Algorithms for Certificates separated by comma eg. RSA_SHA512,DSA_SHA512")
    private List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms = null;

    public List<SignatureAndHashAlgorithm> getSignatureAndHashAlgorithms() {
        if (this.signatureAndHashAlgorithms == null) {
            return null;
        }
        return Collections.unmodifiableList(this.signatureAndHashAlgorithms);
    }

    public void setSignatureAndHashAlgorithms(List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms) {
        this.signatureAndHashAlgorithms = signatureAndHashAlgorithms;
    }

    @Override
    public void applyDelegate(Config config) throws ConfigurationException {
        if (this.signatureAndHashAlgorithms != null) {
            config.setAddSignatureAlgorithmsCertExtension(true);
            config.setDefaultServerSupportedCertificateSignAlgorithms(this.signatureAndHashAlgorithms);
            config.setDefaultClientSupportedCertificateSignAlgorithms(this.signatureAndHashAlgorithms);
            config.setDefaultSelectedSignatureAlgorithmCert(this.signatureAndHashAlgorithms.get(0));
        }
    }
}

