/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config.delegate;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import de.rub.nds.protocol.exception.ConfigurationException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.Delegate;
import de.rub.nds.tlsattacker.core.util.JKSLoader;
import de.rub.nds.tlsattacker.util.KeystoreHandler;
import de.rub.nds.x509attacker.config.X509CertificateConfig;
import de.rub.nds.x509attacker.constants.X509NamedCurve;
import de.rub.nds.x509attacker.filesystem.CertificateBytes;
import de.rub.nds.x509attacker.filesystem.CertificateIo;
import de.rub.nds.x509attacker.signatureengine.keyparsers.PemUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.interfaces.DHPrivateKey;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.tls.crypto.TlsCertificate;

public class CertificateDelegate
extends Delegate {
    public static final int PREDEFINED_LEAF_CERT_INDEX = 0;
    private static final Logger LOGGER = LogManager.getLogger();
    @Parameter(names={"-cert"}, description="PEM encoded certificate file (can contain multiple certificates for a certificate chain)")
    private String certificate = null;
    @Parameter(names={"-key"}, description="PEM encoded private key")
    private String key = null;
    @Parameter(names={"-keystore"}, description="Java Key Store (JKS) file to use as a certificate")
    private String keystore = null;
    @Parameter(names={"-password"}, description="Java Key Store (JKS) file password")
    private String password = null;
    @Parameter(names={"-alias"}, description="Alias of the key to be used from Java Key Store (JKS)")
    private String alias = null;

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public void applyDelegate(Config config) {
        HashMap<String, String> mandatoryParameters = new HashMap<String, String>();
        mandatoryParameters.put("keystore", this.keystore);
        mandatoryParameters.put("password", this.password);
        mandatoryParameters.put("alias", this.alias);
        PrivateKey privateKey = null;
        if (this.key != null) {
            LOGGER.debug("Loading private key");
            privateKey = PemUtil.readPrivateKey((File)new File(this.key));
            this.adjustPrivateKey(config.getCertificateChainConfig().get(0), privateKey);
        }
        if (this.certificate != null) {
            if (privateKey == null) {
                LOGGER.warn("Certificate provided without private key");
            }
            LOGGER.debug("Loading certificate chain");
            try (FileInputStream inputStream = new FileInputStream(this.certificate);){
                List byteList = CertificateIo.readPemCertificateByteList((InputStream)inputStream);
                config.setDefaultExplicitCertificateChain(byteList);
            }
            catch (Exception ex) {
                LOGGER.warn("Could not read certificate", (Throwable)ex);
            }
        }
        ArrayList<String> missingParameters = new ArrayList<String>();
        for (Map.Entry entry : mandatoryParameters.entrySet()) {
            if (entry.getValue() != null) continue;
            missingParameters.add((String)entry.getKey());
        }
        if (missingParameters.size() == 3) {
            return;
        }
        if (!missingParameters.isEmpty()) {
            throw new ParameterException("The following parameters are required for loading a keystore: " + StringUtils.join((Object[])new Set[]{mandatoryParameters.keySet()}));
        }
        try {
            KeyStore store = KeystoreHandler.loadKeyStore((String)this.keystore, (String)this.password);
            TlsCertificate cert = JKSLoader.loadTLSCertificate(store, this.alias);
            privateKey = (PrivateKey)store.getKey(this.alias, this.password.toCharArray());
            List<CertificateBytes> byteList = List.of(new CertificateBytes(cert.getEncoded()));
            config.setDefaultExplicitCertificateChain(byteList);
            this.adjustPrivateKey(config.getCertificateChainConfig().getFirst(), privateKey);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            throw new ConfigurationException("Could not load private Key from Keystore", (Throwable)ex);
        }
    }

    private void adjustPrivateKey(X509CertificateConfig config, PrivateKey privateKey) {
        if (privateKey instanceof RSAPrivateKey) {
            RSAPrivateKey rsaKey = (RSAPrivateKey)privateKey;
            config.setDefaultSubjectRsaPrivateExponent(rsaKey.getPrivateExponent());
            config.setDefaultSubjectRsaModulus(rsaKey.getModulus());
        } else if (privateKey instanceof DSAPrivateKey) {
            DSAPrivateKey dsaKey = (DSAPrivateKey)privateKey;
            config.setDefaultSubjectDsaGenerator(dsaKey.getParams().getG());
            config.setDefaultSubjectDsaPrimeP(dsaKey.getParams().getP());
            config.setDefaultSubjectDsaPrimeQ(dsaKey.getParams().getQ());
            config.setDefaultSubjectDsaPrivateKey(dsaKey.getX());
        } else if (privateKey instanceof DHPrivateKey) {
            DHPrivateKey dhKey = (DHPrivateKey)privateKey;
            config.setDefaultSubjectDhPrivateKey(dhKey.getX());
            config.setDhModulus(dhKey.getParams().getP());
            config.setDhGenerator(dhKey.getParams().getG());
        } else if (privateKey instanceof ECPrivateKey) {
            ECPrivateKey ecKey = (ECPrivateKey)privateKey;
            config.setDefaultSubjectEcPrivateKey(ecKey.getS());
            config.setDefaultSubjectNamedCurve(X509NamedCurve.getX509NamedCurve((ECPrivateKey)ecKey));
        } else {
            throw new UnsupportedOperationException("This private key is not supported:" + this.key);
        }
    }
}

