/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.protocol.crypto.key;

import de.rub.nds.protocol.constants.AsymmetricAlgorithmType;
import de.rub.nds.protocol.constants.DsaParameters;
import de.rub.nds.protocol.crypto.dsa.ExplicitDsaParameters;
import de.rub.nds.protocol.crypto.key.PublicKeyContainer;
import java.math.BigInteger;

public class DsaPublicKey
implements PublicKeyContainer {
    private BigInteger Y;
    private DsaParameters dsaParameters;

    private DsaPublicKey() {
        this.Y = null;
        this.dsaParameters = null;
    }

    public DsaPublicKey(BigInteger Q, BigInteger Y, BigInteger generator, BigInteger modulus) {
        this.dsaParameters = new ExplicitDsaParameters(modulus, Q, generator);
        this.Y = Y;
    }

    public DsaPublicKey(BigInteger Y, DsaParameters dsaParameters) {
        this.dsaParameters = dsaParameters;
        this.Y = Y;
    }

    public DsaParameters getDsaParameters() {
        return this.dsaParameters;
    }

    public void setDsaParameters(DsaParameters dsaParameters) {
        this.dsaParameters = dsaParameters;
    }

    public BigInteger getModulus() {
        return this.dsaParameters.getP();
    }

    public BigInteger getGenerator() {
        return this.dsaParameters.getG();
    }

    public BigInteger getQ() {
        return this.dsaParameters.getQ();
    }

    public BigInteger getY() {
        return this.Y;
    }

    public void setY(BigInteger y) {
        this.Y = y;
    }

    @Override
    public int length() {
        return this.getModulus().bitLength();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dsaParameters == null ? 0 : this.dsaParameters.hashCode());
        result = 31 * result + (this.Y == null ? 0 : this.Y.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DsaPublicKey other = (DsaPublicKey)obj;
        if (this.dsaParameters == null ? other.dsaParameters != null : !this.dsaParameters.equals(other.dsaParameters)) {
            return false;
        }
        return !(this.Y == null ? other.Y != null : !this.Y.equals(other.Y));
    }

    @Override
    public AsymmetricAlgorithmType getAlgorithmType() {
        return AsymmetricAlgorithmType.DSA;
    }
}

