/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.protocol.crypto.key;

import de.rub.nds.protocol.constants.AsymmetricAlgorithmType;
import de.rub.nds.protocol.constants.FfdhGroupParameters;
import de.rub.nds.protocol.crypto.ffdh.ExplicitFfdhGroupParameters;
import de.rub.nds.protocol.crypto.key.PublicKeyContainer;
import java.math.BigInteger;

public class DhPublicKey
implements PublicKeyContainer {
    private FfdhGroupParameters parameters;
    private BigInteger publicKey;

    private DhPublicKey() {
        this.parameters = null;
        this.publicKey = null;
    }

    public DhPublicKey(BigInteger publicKey, BigInteger generator, BigInteger modulus) {
        this.parameters = new ExplicitFfdhGroupParameters(generator, modulus);
        this.publicKey = publicKey;
    }

    public DhPublicKey(BigInteger publicKey, FfdhGroupParameters parameters) {
        this.parameters = parameters;
        this.publicKey = publicKey;
    }

    public BigInteger getModulus() {
        return this.parameters.getModulus();
    }

    public BigInteger getGenerator() {
        return this.parameters.getGenerator();
    }

    public BigInteger getPublicKey() {
        return this.publicKey;
    }

    @Override
    public int length() {
        return this.getModulus().bitLength();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.publicKey == null ? 0 : this.publicKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DhPublicKey other = (DhPublicKey)obj;
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        return !(this.publicKey == null ? other.publicKey != null : !this.publicKey.equals(other.publicKey));
    }

    @Override
    public AsymmetricAlgorithmType getAlgorithmType() {
        return AsymmetricAlgorithmType.DH;
    }
}

