/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.protocol.crypto.ec;

import de.rub.nds.protocol.crypto.ec.EllipticCurve;
import de.rub.nds.protocol.crypto.ec.FieldElement;
import de.rub.nds.protocol.crypto.ec.FieldElementF2m;
import de.rub.nds.protocol.crypto.ec.Point;
import java.math.BigInteger;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EllipticCurveOverF2m
extends EllipticCurve {
    private static final Logger LOGGER = LogManager.getLogger();
    private final FieldElementF2m curveA;
    private final FieldElementF2m curveB;

    public EllipticCurveOverF2m(BigInteger a, BigInteger b, BigInteger polynomial) {
        super(polynomial);
        this.curveA = new FieldElementF2m(a, this.getModulus());
        this.curveB = new FieldElementF2m(b, this.getModulus());
    }

    public EllipticCurveOverF2m(BigInteger a, BigInteger b, BigInteger polynomial, BigInteger x, BigInteger y, BigInteger q) {
        super(polynomial, x, y, q);
        this.curveA = new FieldElementF2m(a, this.getModulus());
        this.curveB = new FieldElementF2m(b, this.getModulus());
    }

    @Override
    public Point getPoint(BigInteger x, BigInteger y) {
        FieldElementF2m elemX = new FieldElementF2m(x, this.getModulus());
        FieldElementF2m elemY = new FieldElementF2m(y, this.getModulus());
        return new Point(elemX, elemY);
    }

    @Override
    public boolean isOnCurve(Point p) {
        if (p.isAtInfinity()) {
            return true;
        }
        if (p.getFieldX().getClass() != FieldElementF2m.class || p.getFieldY().getClass() != FieldElementF2m.class) {
            return false;
        }
        FieldElementF2m x = (FieldElementF2m)p.getFieldX();
        FieldElementF2m y = (FieldElementF2m)p.getFieldY();
        if (x.getModulus() != this.getModulus() || y.getModulus() != this.getModulus()) {
            return false;
        }
        FieldElementF2m leftPart = (FieldElementF2m)y.mult(y).add(x.mult(y));
        FieldElementF2m rightPart = (FieldElementF2m)x.mult(x.mult(x)).add(x.mult(x).mult(this.curveA)).add(this.curveB);
        return leftPart.equals(rightPart);
    }

    @Override
    protected Point inverseAffine(Point p) {
        if (!(p.getFieldX() instanceof FieldElementF2m) || !(p.getFieldY() instanceof FieldElementF2m)) {
            LOGGER.warn("Trying to invert non F2m point with F2m curve. Returning point at (0,0)");
            return this.getPoint(BigInteger.ZERO, BigInteger.ZERO);
        }
        FieldElementF2m x = (FieldElementF2m)p.getFieldX();
        FieldElementF2m invY = (FieldElementF2m)p.getFieldY().add(x);
        return new Point(x, invY);
    }

    @Override
    protected Point additionFormular(Point p, Point q) {
        if (!(p.getFieldX() instanceof FieldElementF2m && p.getFieldY() instanceof FieldElementF2m && q.getFieldX() instanceof FieldElementF2m && q.getFieldY() instanceof FieldElementF2m)) {
            LOGGER.warn("Trying to add non F2m points with F2m curve. Returning point at (0,0)");
            return this.getPoint(BigInteger.ZERO, BigInteger.ZERO);
        }
        try {
            FieldElementF2m y3;
            FieldElementF2m x3;
            FieldElementF2m x1 = (FieldElementF2m)p.getFieldX();
            FieldElementF2m y1 = (FieldElementF2m)p.getFieldY();
            FieldElementF2m x2 = (FieldElementF2m)q.getFieldX();
            FieldElementF2m y2 = (FieldElementF2m)q.getFieldY();
            if (!x1.equals(x2)) {
                FieldElementF2m lambda = (FieldElementF2m)y1.add(y2).divide(x1.add(x2));
                x3 = (FieldElementF2m)lambda.mult(lambda).add(lambda).add(x1).add(x2).add(this.curveA);
                y3 = (FieldElementF2m)lambda.mult(x1.add(x3)).add(x3).add(y1);
            } else {
                FieldElementF2m one = new FieldElementF2m(BigInteger.ONE, this.getModulus());
                FieldElementF2m lambda = (FieldElementF2m)x1.add(y1.divide(x1));
                x3 = (FieldElementF2m)lambda.mult(lambda).add(lambda).add(this.curveA);
                y3 = (FieldElementF2m)x1.mult(x1).add(lambda.add(one).mult(x3));
            }
            return new Point(x3, y3);
        }
        catch (ArithmeticException e) {
            LOGGER.warn("Encountered an arithmetic exception during addition. Returning point at 0,0");
            return this.getPoint(BigInteger.ZERO, BigInteger.ZERO);
        }
    }

    @Override
    public FieldElement createFieldElement(BigInteger value) {
        return new FieldElementF2m(value, this.getModulus());
    }

    @Override
    public Point createAPointOnCurve(BigInteger x, boolean returnBasepointUponError) {
        FieldElementF2m fieldX = new FieldElementF2m(x, this.getModulus());
        if (x.equals(BigInteger.ZERO)) {
            FieldElementF2m y = this.curveB.squarePow(this.getModulus().bitLength() - 2);
            return this.getPoint(x, y.getData());
        }
        FieldElementF2m fieldXInverse = (FieldElementF2m)fieldX.multInv();
        FieldElementF2m fieldXInverseSquare = (FieldElementF2m)fieldXInverse.mult(fieldXInverse);
        FieldElementF2m product = (FieldElementF2m)this.curveB.mult(fieldXInverseSquare);
        FieldElementF2m beta = (FieldElementF2m)fieldX.add(this.curveA).add(product);
        FieldElementF2m z = this.solveQuadraticEquation(beta);
        if (z == null) {
            if (returnBasepointUponError) {
                LOGGER.warn("Was unable to create point on curve - using basepoint instead");
                return this.getBasePoint();
            }
            return null;
        }
        FieldElementF2m y = (FieldElementF2m)fieldX.mult(z);
        Point created = this.getPoint(x, y.getData());
        if (!z.getData().testBit(0)) {
            created = this.inverse(created);
        }
        return created;
    }

    public FieldElementF2m solveQuadraticEquation(FieldElement beta) {
        FieldElementF2m z;
        FieldElementF2m gamma;
        if (beta.getData().equals(BigInteger.ZERO)) {
            return new FieldElementF2m(BigInteger.ONE, beta.getModulus());
        }
        Random randNum = new Random(0L);
        do {
            BigInteger tauData = new BigInteger(32, randNum);
            FieldElementF2m tau = new FieldElementF2m(tauData, beta.getModulus());
            FieldElementF2m w = new FieldElementF2m(beta.getData(), beta.getModulus());
            z = new FieldElementF2m(BigInteger.ZERO, beta.getModulus());
            int i = 1;
            while (i < beta.getModulus().bitLength() - 1) {
                z = (FieldElementF2m)z.mult(z).add(w.mult(w).mult(tau));
                w = (FieldElementF2m)w.mult(w).add(beta);
                ++i;
            }
            if (w.getData().equals(BigInteger.ZERO)) continue;
            LOGGER.warn("No solution to quadratic equation exists!");
            return null;
        } while ((gamma = (FieldElementF2m)z.mult(z).add(z)).getData().equals(BigInteger.ZERO));
        return z;
    }
}

