/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.protocol.constants;

import de.rub.nds.protocol.constants.GroupParameters;
import de.rub.nds.protocol.crypto.CyclicGroup;
import de.rub.nds.protocol.crypto.dsa.DsaGroup;
import java.math.BigInteger;

public abstract class DsaParameters
implements GroupParameters<BigInteger> {
    private final BigInteger p;
    private final BigInteger q;
    private final BigInteger g;

    public DsaParameters(BigInteger p, BigInteger q, BigInteger g) {
        this.p = p;
        this.q = q;
        this.g = g;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getG() {
        return this.g;
    }

    @Override
    public int getElementSizeBits() {
        return this.p.bitLength();
    }

    @Override
    public int getElementSizeBytes() {
        return (int)Math.ceil((double)this.getElementSizeBits() / 8.0);
    }

    @Override
    public CyclicGroup<BigInteger> getGroup() {
        return new DsaGroup(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.p == null ? 0 : this.p.hashCode());
        result = 31 * result + (this.q == null ? 0 : this.q.hashCode());
        result = 31 * result + (this.g == null ? 0 : this.g.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DsaParameters other = (DsaParameters)obj;
        if (this.p == null ? other.p != null : !this.p.equals(other.p)) {
            return false;
        }
        if (this.q == null ? other.q != null : !this.q.equals(other.q)) {
            return false;
        }
        return !(this.g == null ? other.g != null : !this.g.equals(other.g));
    }
}

