/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.preparator;

import de.rub.nds.asn1.model.Asn1Encodable;
import de.rub.nds.asn1.model.Asn1Field;
import de.rub.nds.asn1.model.Asn1Ia5String;
import de.rub.nds.asn1.model.Asn1ObjectIdentifier;
import de.rub.nds.asn1.model.Asn1OctetString;
import de.rub.nds.asn1.oid.ObjectIdentifier;
import de.rub.nds.asn1.preparator.Asn1PreparatorHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.x509.model.GeneralName;
import de.rub.nds.x509attacker.x509.preparator.X509Asn1FieldPreparator;
import de.rub.nds.x509attacker.x509.preparator.X509Preparator;

public class GeneralNamePreparator
implements X509Preparator {
    private final GeneralName generalName;
    private final X509Chooser chooser;

    public GeneralNamePreparator(X509Chooser chooser, GeneralName generalName) {
        this.generalName = generalName;
        this.chooser = chooser;
    }

    @Override
    public void prepare() {
        switch (this.generalName.getGeneralNameChoiceTypeConfig()) {
            case DIRECTORY_NAME: {
                this.generalName.makeSelection(this.generalName.getDirectoryName());
                break;
            }
            case DNS_NAME: {
                this.generalName.makeSelection((Asn1Encodable)this.generalName.getDnsName());
                break;
            }
            case EDI_PARTY_NAME: {
                this.generalName.makeSelection(this.generalName.getEdiPartyName());
                break;
            }
            case IP_ADDRESS: {
                this.generalName.makeSelection((Asn1Encodable)this.generalName.getIpAddress());
                break;
            }
            case OTHER_NAME: {
                this.generalName.makeSelection(this.generalName.getOtherName());
                break;
            }
            case REGISTERED_ID: {
                this.generalName.makeSelection((Asn1Encodable)this.generalName.getRegisteredId());
                break;
            }
            case RFC822_NAME: {
                this.generalName.makeSelection((Asn1Encodable)this.generalName.getRfc822Name());
                break;
            }
            case UNIFORM_RESOURCE_IDENTIFIER: {
                this.generalName.makeSelection((Asn1Encodable)this.generalName.getUniformResourceIdentifier());
                break;
            }
            case X400_ADDRESS: {
                this.generalName.makeSelection(this.generalName.getX400Address());
                break;
            }
            default: {
                throw new UnsupportedOperationException("GeneralNameChoiceType " + this.generalName.getGeneralNameChoiceTypeConfig().name() + " not yet implemented.");
            }
        }
        this.generalName.getPreparator(this.chooser).prepare();
        if (!(this.generalName.getSelectedChoice() instanceof Asn1Field)) {
            throw new UnsupportedOperationException("GeneralName only supports Asn1Field and X509 Components at the time");
        }
        HelperPreparator preparator = new HelperPreparator(this, this.chooser, (Asn1Field)this.generalName.getSelectedChoice(), this.generalName.getGeneralNameConfigValue());
        preparator.prepare();
    }

    private class HelperPreparator<T extends Asn1Field>
    extends X509Asn1FieldPreparator<T> {
        private Object value;

        /*
         * WARNING - Possible parameter corruption
         */
        public HelperPreparator(X509Chooser chooser, T type, Object value) {
            super(chooser, type);
            this.value = value;
        }

        protected byte[] encodeContent() {
            if (this.field instanceof Asn1Ia5String) {
                Asn1PreparatorHelper.prepareField((Asn1Ia5String)((Asn1Ia5String)this.field), (String)((String)this.value));
            } else if (this.field instanceof Asn1ObjectIdentifier) {
                Asn1PreparatorHelper.prepareField((Asn1ObjectIdentifier)((Asn1ObjectIdentifier)this.field), (ObjectIdentifier)new ObjectIdentifier((String)this.value));
            } else if (this.field instanceof Asn1OctetString) {
                Asn1PreparatorHelper.prepareField((Asn1OctetString)((Asn1OctetString)this.field), (byte[])((byte[])this.value));
            } else {
                throw new UnsupportedOperationException("Unimplemented Asn1Field: " + this.field.getClass().getName());
            }
            return this.field.getContent().getOriginalValue();
        }
    }
}

