/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.preparator;

import de.rub.nds.asn1.model.Asn1Encodable;
import de.rub.nds.asn1.model.Asn1ObjectIdentifier;
import de.rub.nds.asn1.oid.ObjectIdentifier;
import de.rub.nds.asn1.preparator.Asn1PreparatorHelper;
import de.rub.nds.protocol.constants.SignatureAlgorithm;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.x509.model.CertificateSignatureAlgorithmIdentifier;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.PublicParameters;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509DssParameters;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509EcNamedCurveParameters;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509NullParameters;
import de.rub.nds.x509attacker.x509.preparator.X509ContainerPreparator;

public class CertificateSignatureAlgorithmIdentifierPreparator
extends X509ContainerPreparator<CertificateSignatureAlgorithmIdentifier> {
    public CertificateSignatureAlgorithmIdentifierPreparator(X509Chooser chooser, CertificateSignatureAlgorithmIdentifier certificateSignatureAlgorithmIdentifier) {
        super(chooser, certificateSignatureAlgorithmIdentifier);
    }

    @Override
    public void prepareSubComponents() {
        if (this.chooser.getConfig().isSignatureAlgorithmOidInvalid()) {
            Asn1PreparatorHelper.prepareField((Asn1ObjectIdentifier)((CertificateSignatureAlgorithmIdentifier)this.field).getAlgorithm(), (ObjectIdentifier)new ObjectIdentifier("1.2.3.4.5.6.7.8"));
        } else if (this.chooser.getConfig().getDifferentSignatureAlgorithmOid() != null) {
            Asn1PreparatorHelper.prepareField((Asn1ObjectIdentifier)((CertificateSignatureAlgorithmIdentifier)this.field).getAlgorithm(), (ObjectIdentifier)this.chooser.getConfig().getDifferentSignatureAlgorithmOid());
        } else {
            Asn1PreparatorHelper.prepareField((Asn1ObjectIdentifier)((CertificateSignatureAlgorithmIdentifier)this.field).getAlgorithm(), (ObjectIdentifier)this.chooser.getSignatureAlgorithm().getOid());
        }
        PublicParameters signatureParameters = ((CertificateSignatureAlgorithmIdentifier)this.field).getParameters();
        if (signatureParameters == null) {
            signatureParameters = this.createSignatureParameters();
            ((CertificateSignatureAlgorithmIdentifier)this.field).setParameters(signatureParameters);
        }
        signatureParameters.getPreparator(this.chooser).prepare();
        signatureParameters.getHandler(this.chooser).adjustContextAfterPrepare();
        ((CertificateSignatureAlgorithmIdentifier)this.field).setParameters(signatureParameters);
    }

    private PublicParameters createSignatureParameters() {
        SignatureAlgorithm publicKeyType = this.chooser.getSignatureAlgorithm().getSignatureAlgorithm();
        return switch (publicKeyType) {
            case SignatureAlgorithm.DSA -> new X509DssParameters("dssParameters");
            case SignatureAlgorithm.ECDSA -> new X509EcNamedCurveParameters("ecNamedCurve");
            case SignatureAlgorithm.RSA_PKCS1 -> new X509NullParameters("nullParameters");
            default -> throw new UnsupportedOperationException("Unknown PublicKeyType: " + String.valueOf(publicKeyType));
        };
    }

    @Override
    public byte[] encodeChildrenContent() {
        if (this.chooser.getConfig().isIncludeSignatureAlgorithm()) {
            if (((CertificateSignatureAlgorithmIdentifier)this.field).getParameters() != null) {
                return this.encodeChildren(new Asn1Encodable[]{((CertificateSignatureAlgorithmIdentifier)this.field).getAlgorithm(), ((CertificateSignatureAlgorithmIdentifier)this.field).getParameters()});
            }
            return this.encodeChildren(new Asn1Encodable[]{((CertificateSignatureAlgorithmIdentifier)this.field).getAlgorithm()});
        }
        return new byte[0];
    }
}

