/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.parser.publickey.parameters;

import de.rub.nds.asn1.model.Asn1BitString;
import de.rub.nds.asn1.model.Asn1Integer;
import de.rub.nds.asn1.parser.ParserHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509DhValidationParms;
import de.rub.nds.x509attacker.x509.parser.X509ComponentContainerParser;
import java.io.BufferedInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class X509DhValidationParmsParser
extends X509ComponentContainerParser<X509DhValidationParms> {
    private Logger LOGGER = LogManager.getLogger();

    public X509DhValidationParmsParser(X509Chooser chooser, X509DhValidationParms x509DhValidationParms) {
        super(chooser, x509DhValidationParms);
    }

    @Override
    protected void parseSubcomponents(BufferedInputStream inputStream) {
        this.LOGGER.debug("Parsing DhValidationParms");
        this.parseSeed(inputStream);
        this.parsePgenCounter(inputStream);
    }

    private void parsePgenCounter(BufferedInputStream inputStream) {
        this.LOGGER.debug("Parsed PgenCounter: {}", ((X509DhValidationParms)this.encodable).getPgenCounter().getValue().getValue());
        ParserHelper.parseAsn1Integer((Asn1Integer)((X509DhValidationParms)this.encodable).getPgenCounter(), (BufferedInputStream)inputStream);
    }

    private void parseSeed(BufferedInputStream inputStream) {
        this.LOGGER.debug("Parsed Seed: {}", ((X509DhValidationParms)this.encodable).getSeed().getContent().getValue());
        ParserHelper.parseAsn1BitString((Asn1BitString)((X509DhValidationParms)this.encodable).getSeed(), (BufferedInputStream)inputStream);
    }
}

