/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.parser.extension;

import de.rub.nds.asn1.constants.TagClass;
import de.rub.nds.asn1.model.Asn1Boolean;
import de.rub.nds.asn1.model.Asn1ObjectIdentifier;
import de.rub.nds.asn1.model.Asn1OctetString;
import de.rub.nds.asn1.parser.ParserHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.x509.model.Extension;
import de.rub.nds.x509attacker.x509.parser.X509ComponentContainerParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract class ExtensionParser<Encodable extends Extension>
extends X509ComponentContainerParser<Encodable> {
    private final Logger LOGGER = LogManager.getLogger();

    public ExtensionParser(X509Chooser chooser, Encodable extension) {
        super(chooser, extension);
    }

    @Override
    protected void parseSubcomponents(BufferedInputStream inputStream) {
        this.parseOid(inputStream);
        if (ParserHelper.canParse((BufferedInputStream)inputStream, (TagClass)TagClass.UNIVERSAL, (int)1)) {
            this.parseCritical(inputStream);
        }
        this.parseExtnValue(inputStream);
        this.parseExtensionContent(new BufferedInputStream(new ByteArrayInputStream((byte[])((Extension)this.encodable).getExtnValue().getValue().getValue())));
    }

    private void parseOid(BufferedInputStream bufferedInputStream) {
        ParserHelper.parseAsn1ObjectIdentifier((Asn1ObjectIdentifier)((Extension)this.encodable).getExtnID(), (BufferedInputStream)bufferedInputStream);
        this.LOGGER.debug("Parsed extension OID: {}", (Object)((Extension)this.encodable).getExtnID());
    }

    private void parseCritical(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1Boolean((Asn1Boolean)((Extension)this.encodable).getCritical(), (BufferedInputStream)inputStream);
        this.LOGGER.debug("Parsed critical extension: {}", (Object)((Extension)this.encodable).getCritical());
    }

    private void parseExtnValue(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1OctetString((Asn1OctetString)((Extension)this.encodable).getExtnValue(), (BufferedInputStream)inputStream);
    }

    abstract void parseExtensionContent(BufferedInputStream var1);
}

