/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.parser.extension;

import de.rub.nds.asn1.constants.TagClass;
import de.rub.nds.asn1.model.Asn1Field;
import de.rub.nds.asn1.model.Asn1Integer;
import de.rub.nds.asn1.parser.ParserHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.x509.model.extensions.AuthorityKeyIdentifier;
import de.rub.nds.x509attacker.x509.parser.extension.ExtensionParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;

public class AuthorityKeyIdentifierParser
extends ExtensionParser<AuthorityKeyIdentifier> {
    public AuthorityKeyIdentifierParser(X509Chooser chooser, AuthorityKeyIdentifier extension) {
        super(chooser, extension);
    }

    @Override
    void parseExtensionContent(BufferedInputStream inputStream) {
        ParserHelper.parseStructure((Asn1Field)((AuthorityKeyIdentifier)this.encodable).getWrappingSequence(), (BufferedInputStream)inputStream);
        BufferedInputStream contentStream = new BufferedInputStream(new ByteArrayInputStream((byte[])((AuthorityKeyIdentifier)this.encodable).getWrappingSequence().getContent().getValue()));
        if (this.hasKeyIdentifierField(contentStream)) {
            this.parseKeyIdentifier(contentStream);
        }
        if (this.hasAuthorityCertIssuerField(contentStream)) {
            this.parseAuthorityCertIssuer(contentStream);
        }
        if (this.hasAuthorityCertSerialNumberField(contentStream)) {
            this.parseAuthorityCertSerialNumber(contentStream);
        }
    }

    private void parseKeyIdentifier(BufferedInputStream inputStream) {
        ParserHelper.parseStructure((Asn1Field)((AuthorityKeyIdentifier)this.encodable).getKeyIdentifier(), (BufferedInputStream)inputStream);
    }

    private void parseAuthorityCertIssuer(BufferedInputStream inputStream) {
    }

    private void parseAuthorityCertSerialNumber(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1Integer((Asn1Integer)((AuthorityKeyIdentifier)this.encodable).getAuthorityCertSerialNumber(), (BufferedInputStream)inputStream);
    }

    private boolean hasKeyIdentifierField(BufferedInputStream inputStream) {
        return ParserHelper.canParse((BufferedInputStream)inputStream, (TagClass)TagClass.CONTEXT_SPECIFIC, (int)1);
    }

    private boolean hasAuthorityCertIssuerField(BufferedInputStream inputStream) {
        return ParserHelper.canParse((BufferedInputStream)inputStream, (TagClass)TagClass.CONTEXT_SPECIFIC, (int)2);
    }

    private boolean hasAuthorityCertSerialNumberField(BufferedInputStream inputStream) {
        return ParserHelper.canParse((BufferedInputStream)inputStream, (TagClass)TagClass.CONTEXT_SPECIFIC, (int)3);
    }
}

