/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.parser;

import de.rub.nds.asn1.model.Asn1Choice;
import de.rub.nds.asn1.model.Asn1Encodable;
import de.rub.nds.asn1.parser.ParserHelper;
import de.rub.nds.asn1.util.Asn1Header;
import de.rub.nds.protocol.exception.ParserException;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.x509.model.X509Component;
import de.rub.nds.x509attacker.x509.parser.X509Parser;
import java.io.BufferedInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class X509ChoiceParser
implements X509Parser {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Asn1Choice choice;
    private final X509Chooser chooser;

    public X509ChoiceParser(X509Chooser chooser, Asn1Choice choice) {
        this.choice = choice;
        this.chooser = chooser;
    }

    @Override
    public void parse(BufferedInputStream inputStream) {
        try {
            LOGGER.debug("Parsing choice. Looking ahead. Bytes in stream: {}", (Object)inputStream.available());
            Asn1Header header = ParserHelper.lookAhead((BufferedInputStream)inputStream);
            LOGGER.debug("Found header: {}", (Object)header.toString());
            this.choice.makeSelection(header.getTagClass(), Boolean.valueOf(header.getTagConstructed().getBooleanValue()), Integer.valueOf(header.getTagNumber()));
            Asn1Encodable selectedChoice = this.choice.getSelectedChoice();
            if (selectedChoice == null) {
                throw new ParserException("Cannot make a selection for CHOICE: " + this.choice.getIdentifier());
            }
            LOGGER.debug("Selected: {} ({})", (Object)selectedChoice.getIdentifier(), (Object)selectedChoice.getClass().getSimpleName());
            if (selectedChoice instanceof X509Component) {
                X509Component x509Component = (X509Component)selectedChoice;
                x509Component.getParser(this.chooser).parse(inputStream);
                x509Component.getHandler(this.chooser).adjustContextAfterParse();
            } else {
                ParserHelper.parseGenericField((Asn1Encodable)selectedChoice, (BufferedInputStream)inputStream);
            }
            LOGGER.debug("Finished parsing of X509Choice");
        }
        catch (Exception E) {
            throw new ParserException(String.format("Exception occured in X509ChoiceParser parsing for %s", this.choice.getIdentifier()), (Throwable)E);
        }
    }
}

