/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.constants;

import de.rub.nds.asn1.oid.ObjectIdentifier;
import de.rub.nds.protocol.constants.SignatureAlgorithm;
import java.util.HashMap;
import java.util.Map;

public enum X509PublicKeyType {
    RSA("RSA", "1.2.840.113549.1.1.1"),
    DSA("DSA", "1.2.840.10040.4.1"),
    DH("Diffie-Hellman", "1.2.840.113549.1.3.1"),
    KEA("Key Exchange Algorithm", "2.16.840.1.101.2.1.1.22"),
    ECDH_ECDSA("Elliptic Curve", "1.2.840.10045.2.1"),
    RSASSA_PSS("RSA-PSS", "1.2.840.113549.1.1.10"),
    RSAES_OAEP("RSA-OAEP", "1.2.840.113549.1.1.7"),
    GOST_R3411_94("GOST_R3411_94", "1.2.643.2.2.20"),
    GOST_R3411_2001("GOST_R3411_2001", "1.2.643.2.2.19"),
    GOST_R3411_2012("GOST_R3411_2001", "1.2.643.2.2.19"),
    ECDH_ONLY("ECDH", "1.3.132.1.12"),
    ECMQV("ECMQV", "1.3.132.1.13"),
    X25519("X25519", "1.3.101.110"),
    X448("X448", "1.3.101.111"),
    ED25519("Ed25519", "1.3.101.112"),
    ED448("Ed448", "1.3.101.113");

    private static final Map<String, X509PublicKeyType> oidMap;
    private final String humanReadableName;
    private final ObjectIdentifier oid;

    private X509PublicKeyType(String humanReadableName, String oid) {
        this.humanReadableName = humanReadableName;
        this.oid = new ObjectIdentifier(oid);
    }

    public String getHumanReadableName() {
        return this.humanReadableName;
    }

    public ObjectIdentifier getOid() {
        return this.oid;
    }

    public static X509PublicKeyType decodeFromOidBytes(byte[] oidBytes) {
        ObjectIdentifier objectIdentifier = new ObjectIdentifier(oidBytes);
        return oidMap.get(objectIdentifier.toString());
    }

    public boolean canBeUsedWithSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        switch (this.ordinal()) {
            case 2: {
                return false;
            }
            case 1: {
                return signatureAlgorithm == SignatureAlgorithm.DSA;
            }
            case 4: {
                return signatureAlgorithm == SignatureAlgorithm.ECDSA;
            }
            case 10: {
                return false;
            }
            case 11: {
                throw new UnsupportedOperationException("Not implemented: " + String.valueOf((Object)this));
            }
            case 14: {
                return signatureAlgorithm == SignatureAlgorithm.ED25519;
            }
            case 15: {
                return signatureAlgorithm == SignatureAlgorithm.ED448;
            }
            case 7: 
            case 8: {
                return signatureAlgorithm == SignatureAlgorithm.GOSTR34102001;
            }
            case 9: {
                return signatureAlgorithm == SignatureAlgorithm.GOSTR34102012_256 || signatureAlgorithm == SignatureAlgorithm.GOSTR34102012_512;
            }
            case 3: {
                throw new UnsupportedOperationException("Not implemented: " + String.valueOf((Object)this));
            }
            case 0: {
                return signatureAlgorithm == SignatureAlgorithm.RSA_PKCS1;
            }
            case 5: {
                return signatureAlgorithm == SignatureAlgorithm.RSA_SSA_PSS;
            }
            case 12: {
                return false;
            }
            case 13: {
                return false;
            }
            case 6: {
                throw new UnsupportedOperationException("Not implemented: " + String.valueOf((Object)this));
            }
        }
        throw new UnsupportedOperationException("Not implemented: " + String.valueOf((Object)this));
    }

    public boolean isEc() {
        switch (this.ordinal()) {
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return true;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                return false;
            }
        }
        throw new UnsupportedOperationException("Not yet implemented: " + this.name());
    }

    static {
        oidMap = new HashMap<String, X509PublicKeyType>();
        for (X509PublicKeyType algorithm : X509PublicKeyType.values()) {
            oidMap.put(algorithm.getOid().toString(), algorithm);
        }
    }
}

