/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.tcp;

import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.tcp.TcpTransportHandler;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerTcpTransportHandler
extends TcpTransportHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private ServerSocket serverSocket;
    private SocketManagement socketManagement = SocketManagement.DEFAULT;

    public ServerTcpTransportHandler(Connection con) {
        super(con);
        this.srcPort = con.getPort();
    }

    public ServerTcpTransportHandler(long firstTimeout, long timeout, int port) {
        super(timeout, ConnectionEndType.SERVER);
        this.srcPort = port;
    }

    public ServerTcpTransportHandler(long firstTimeout, long timeout, ServerSocket serverSocket) {
        super(timeout, ConnectionEndType.SERVER);
        this.srcPort = serverSocket.getLocalPort();
        this.serverSocket = serverSocket;
        this.socketManagement = SocketManagement.EXTERNAL_SERVER_SOCKET;
    }

    public ServerTcpTransportHandler(Connection con, Socket socket) {
        super(con);
        this.srcPort = socket.getLocalPort();
        this.socket = socket;
        this.socketManagement = SocketManagement.EXTERNAL_SOCKET;
    }

    public void closeServerSocket() throws IOException {
        if (this.serverSocket == null) {
            throw new IOException("TransportHandler not initialized");
        }
        this.serverSocket.close();
    }

    @Override
    public void closeConnection() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.socketManagement == SocketManagement.DEFAULT) {
            this.closeServerSocket();
        }
    }

    @Override
    public void initialize() throws IOException {
        if (this.socketManagement != SocketManagement.EXTERNAL_SOCKET) {
            if (this.serverSocket == null || this.serverSocket.isClosed()) {
                throw new IOException("TransportHandler not preinitialized");
            }
            this.socket = this.serverSocket.accept();
            this.socket.setSoTimeout((int)this.timeout);
        }
        this.dstPort = this.socket.getPort();
        this.cachedSocketState = null;
        LOGGER.info("Connection established from ports {} -> {}", (Object)this.srcPort, (Object)this.dstPort);
        this.setStreams(new PushbackInputStream(this.socket.getInputStream()), this.socket.getOutputStream());
    }

    @Override
    public void preInitialize() throws IOException {
        if (this.socketManagement != SocketManagement.EXTERNAL_SOCKET) {
            if (this.serverSocket == null || this.serverSocket.isClosed()) {
                this.serverSocket = new ServerSocket(this.srcPort);
            }
            this.srcPort = this.serverSocket.getLocalPort();
        }
    }

    @Override
    public boolean isClosed() throws IOException {
        if (this.isInitialized()) {
            if (this.socket != null && (this.socket.isClosed() || this.socket.isInputShutdown())) {
                if (this.socketManagement != SocketManagement.DEFAULT) {
                    return true;
                }
                if (this.serverSocket.isClosed()) {
                    return true;
                }
            } else if (this.socket == null) {
                if (this.socketManagement != SocketManagement.DEFAULT) {
                    return true;
                }
                if (this.serverSocket.isClosed()) {
                    return true;
                }
            }
            return false;
        }
        throw new IOException("TransportHandler is not initialized!");
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    @Override
    public void closeClientConnection() throws IOException {
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
    }

    @Override
    public Integer getSrcPort() {
        if (this.isInitialized()) {
            return this.socket.getLocalPort();
        }
        return this.srcPort;
    }

    @Override
    public void setSrcPort(int port) {
        if (this.isInitialized()) {
            throw new RuntimeException("Cannot change server port of uninitialized TransportHandler");
        }
        this.srcPort = port;
    }

    @Override
    public Integer getDstPort() {
        if (!this.isInitialized()) {
            throw new RuntimeException("Cannot access client port of uninitialized TransportHandler");
        }
        return this.socket.getPort();
    }

    @Override
    public void setDstPort(int port) {
        throw new RuntimeException("A ServerTransportHandler cannot set the client port");
    }

    private static enum SocketManagement {
        DEFAULT,
        EXTERNAL_SERVER_SOCKET,
        EXTERNAL_SOCKET;

    }
}

