/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport;

import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.TransportHandlerType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.Objects;

@XmlTransient
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class Connection
implements Serializable {
    protected Integer port = null;
    protected String ip = null;
    protected String ipv6 = null;
    protected String hostname = null;
    protected Integer proxyDataPort = null;
    protected String proxyDataHostname = null;
    protected Integer proxyControlPort = null;
    protected String proxyControlHostname = null;
    protected TransportHandlerType transportHandlerType = null;
    protected Integer timeout = null;
    protected Integer connectionTimeout = null;
    protected Integer sourcePort = null;
    protected Boolean useIpv6 = null;

    public Connection() {
    }

    public Connection(Integer port) {
        this.port = port;
    }

    public Connection(Integer port, String hostname) {
        this.port = port;
        this.hostname = hostname;
    }

    public Connection(Connection other) {
        this.port = other.port;
        this.ip = other.ip;
        this.ipv6 = other.ipv6;
        this.hostname = other.hostname;
        this.proxyDataPort = other.proxyDataPort;
        this.proxyDataHostname = other.proxyDataHostname;
        this.proxyControlPort = other.proxyControlPort;
        this.proxyControlHostname = other.proxyControlHostname;
        this.transportHandlerType = other.transportHandlerType;
        this.timeout = other.timeout;
        this.connectionTimeout = other.connectionTimeout;
        this.sourcePort = other.sourcePort;
        this.useIpv6 = other.useIpv6;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getIpv6() {
        return this.ipv6;
    }

    public void setIpv6(String ipv6) {
        this.ipv6 = ipv6;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public Integer getProxyDataPort() {
        return this.proxyDataPort;
    }

    public void setProxyDataPort(Integer proxyDataPort) {
        this.proxyDataPort = proxyDataPort;
    }

    public String getProxyDataHostname() {
        return this.proxyDataHostname;
    }

    public void setProxyDataHostname(String proxyDataHostname) {
        this.proxyDataHostname = proxyDataHostname;
    }

    public String getProxyControlHostname() {
        return this.proxyControlHostname;
    }

    public void setProxyControlHostname(String proxyControlHostname) {
        this.proxyControlHostname = proxyControlHostname;
    }

    public Integer getProxyControlPort() {
        return this.proxyControlPort;
    }

    public void setProxyControlPort(Integer proxyControlPort) {
        this.proxyControlPort = proxyControlPort;
    }

    public void setTransportHandlerType(TransportHandlerType transportHandlerType) {
        this.transportHandlerType = transportHandlerType;
    }

    public TransportHandlerType getTransportHandlerType() {
        return this.transportHandlerType;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getSourcePort() {
        return this.sourcePort;
    }

    public void setSourcePort(Integer sourcePort) {
        this.sourcePort = sourcePort;
    }

    public Boolean getUseIpv6() {
        return this.useIpv6;
    }

    public void setUseIpv6(Boolean useIpv6) {
        this.useIpv6 = useIpv6;
    }

    public abstract ConnectionEndType getLocalConnectionEndType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connection that = (Connection)o;
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.ip, that.ip)) {
            return false;
        }
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.proxyDataPort, that.proxyDataPort)) {
            return false;
        }
        if (!Objects.equals(this.proxyDataHostname, that.proxyDataHostname)) {
            return false;
        }
        if (!Objects.equals(this.proxyControlPort, that.proxyControlPort)) {
            return false;
        }
        if (!Objects.equals(this.proxyControlHostname, that.proxyControlHostname)) {
            return false;
        }
        if (this.transportHandlerType != that.transportHandlerType) {
            return false;
        }
        if (!Objects.equals(this.timeout, that.timeout)) {
            return false;
        }
        if (!Objects.equals(this.connectionTimeout, that.connectionTimeout)) {
            return false;
        }
        if (!Objects.equals(this.sourcePort, that.sourcePort)) {
            return false;
        }
        return Objects.equals(this.useIpv6, that.useIpv6);
    }

    public int hashCode() {
        int result = this.port != null ? this.port.hashCode() : 0;
        result = 31 * result + (this.ip != null ? this.ip.hashCode() : 0);
        result = 31 * result + (this.ipv6 != null ? this.ipv6.hashCode() : 0);
        result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
        result = 31 * result + (this.proxyDataPort != null ? this.proxyDataPort.hashCode() : 0);
        result = 31 * result + (this.proxyDataHostname != null ? this.proxyDataHostname.hashCode() : 0);
        result = 31 * result + (this.proxyControlPort != null ? this.proxyControlPort.hashCode() : 0);
        result = 31 * result + (this.proxyControlHostname != null ? this.proxyControlHostname.hashCode() : 0);
        result = 31 * result + (this.transportHandlerType != null ? this.transportHandlerType.hashCode() : 0);
        result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
        result = 31 * result + (this.connectionTimeout != null ? this.connectionTimeout.hashCode() : 0);
        result = 31 * result + (this.sourcePort != null ? this.sourcePort.hashCode() : 0);
        result = 31 * result + (this.useIpv6 != null ? this.useIpv6.hashCode() : 0);
        return result;
    }

    protected void addProperties(StringBuilder sb) {
        sb.append("host=").append(this.hostname);
        sb.append(" ip=").append(this.ip);
        sb.append(" ipv6=").append(this.ipv6);
        sb.append(" port=").append(this.port);
        sb.append(" proxyDataHost=").append(this.proxyDataHostname);
        sb.append(" proxyDataPort=").append(this.proxyDataPort);
        sb.append(" proxyControlHost=").append(this.proxyControlHostname);
        sb.append(" proxyControlPort=").append(this.proxyControlPort);
        sb.append(" type=").append((Object)this.transportHandlerType);
        sb.append(" timeout=").append(this.timeout);
        sb.append(" connectionTimeout=").append(this.connectionTimeout);
        sb.append(" sourcePort=").append(this.sourcePort);
        sb.append(" useIpv6=").append(this.useIpv6);
    }

    protected void addCompactProperties(StringBuilder sb) {
        sb.append(this.hostname).append(":").append(this.port);
    }
}

