/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.proxy;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.proxy.ProxyConfig;
import de.rub.nds.tlsattacker.proxy.ProxyConnection;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.security.cert.CertificateException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpsProxy {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ProxyConfig proxyConfig;

    public HttpsProxy(ProxyConfig config) {
        this.proxyConfig = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        LOGGER.info("Proxy started...");
        ServerSocket serverSocket = new ServerSocket(this.proxyConfig.getListeningPort());
        while (true) {
            try {
                Socket socket = serverSocket.accept();
                LOGGER.info("Received a connection");
                Config config = this.proxyConfig.getDefaultConfig() != null ? Config.createConfig(new File(this.proxyConfig.getDefaultConfig())) : new Config();
                ProxyConnection proxyConnection = new ProxyConnection(this.proxyConfig, config, socket);
                Thread t = new Thread(proxyConnection);
                t.start();
                continue;
            }
            catch (IOException ex) {
                LOGGER.error("Caught an IO exception...", (Throwable)ex);
                continue;
            }
            finally {
                try {
                    serverSocket.close();
                }
                catch (IOException ex) {
                    LOGGER.error("Caught an IO exception...", (Throwable)ex);
                }
                continue;
            }
            break;
        }
    }

    public SSLContext createContext() throws KeyStoreException, NoSuchAlgorithmException, FileNotFoundException, IOException, CertificateException, UnrecoverableKeyException, KeyManagementException, java.security.cert.CertificateException {
        SSLContext context = SSLContext.getInstance("TLS");
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        KeyStore keyStore = KeyStore.getInstance("JKS");
        char[] passphrase = this.proxyConfig.getPassword().toCharArray();
        try (FileInputStream fis = new FileInputStream(this.proxyConfig.getServerCertificate());){
            keyStore.load(fis, passphrase);
        }
        keyManagerFactory.init(keyStore, passphrase);
        context.init(keyManagerFactory.getKeyManagers(), new TrustManager[]{new X509ExtendedTrustManager(this){

            @Override
            public void checkClientTrusted(X509Certificate[] xcs, String string, Socket socket) throws java.security.cert.CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] xcs, String string, Socket socket) throws java.security.cert.CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] xcs, String string, SSLEngine ssle) throws java.security.cert.CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] xcs, String string, SSLEngine ssle) throws java.security.cert.CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] xcs, String string) throws java.security.cert.CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] xcs, String string) throws java.security.cert.CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }}, null);
        return context;
    }
}

