/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.util;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    FileHelper.deleteFolder(f);
                    continue;
                }
                assert (f.delete());
            }
        }
        assert (folder.delete());
    }

    public static String getResourceAsString(Class<?> currentClass, String resourceFilePath) {
        String contents;
        if (!((String)resourceFilePath).startsWith("/")) {
            resourceFilePath = "/" + (String)resourceFilePath;
        }
        try (InputStream is = currentClass.getResourceAsStream((String)resourceFilePath);){
            contents = FileHelper.inputStreamToString(is);
        }
        catch (IOException ex) {
            LOGGER.error("Unable to load resource file {}", resourceFilePath);
            return null;
        }
        return contents;
    }

    public static String inputStreamToString(InputStream is) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            String string;
            try (SilentByteArrayOutputStream bos = new SilentByteArrayOutputStream();){
                int result = bis.read();
                while (result != -1) {
                    bos.write((int)((byte)result));
                    result = bis.read();
                }
                string = bos.toString(StandardCharsets.UTF_8);
            }
            return string;
        }
    }

    private FileHelper() {
    }
}

