/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.parser;

import de.rub.nds.asn1.constants.TagClass;
import de.rub.nds.asn1.constants.TagConstructed;
import de.rub.nds.asn1.constants.UniversalTagNumber;
import de.rub.nds.asn1.model.Asn1BitString;
import de.rub.nds.asn1.model.Asn1Boolean;
import de.rub.nds.asn1.model.Asn1Encodable;
import de.rub.nds.asn1.model.Asn1Field;
import de.rub.nds.asn1.model.Asn1GeneralizedTime;
import de.rub.nds.asn1.model.Asn1Ia5String;
import de.rub.nds.asn1.model.Asn1Integer;
import de.rub.nds.asn1.model.Asn1Null;
import de.rub.nds.asn1.model.Asn1ObjectIdentifier;
import de.rub.nds.asn1.model.Asn1OctetString;
import de.rub.nds.asn1.model.Asn1PrintableString;
import de.rub.nds.asn1.model.Asn1T61String;
import de.rub.nds.asn1.model.Asn1UnknownField;
import de.rub.nds.asn1.model.Asn1UnknownSequence;
import de.rub.nds.asn1.model.Asn1UnknownSet;
import de.rub.nds.asn1.model.Asn1UtcTime;
import de.rub.nds.asn1.model.Asn1Utf8String;
import de.rub.nds.asn1.oid.ObjectIdentifier;
import de.rub.nds.asn1.util.Asn1Header;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.protocol.exception.ParserException;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParserHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    private ParserHelper() {
    }

    public static Asn1Field parseTagNumberOrUnkownField(BufferedInputStream inputStream, TagClass tagClass, UniversalTagNumber ... tagNumbers) {
        if (tagNumbers.length == 0) {
            throw new ParserException("No tag numbers provided");
        }
        if (tagClass != TagClass.UNIVERSAL) {
            throw new ParserException("Cannot parse this tag number generically.");
        }
        Asn1Header header = ParserHelper.lookAhead(inputStream);
        UniversalTagNumber foundNumber = null;
        if (header.getTagClass() == tagClass) {
            UniversalTagNumber[] universalTagNumberArray = tagNumbers;
            int n = tagNumbers.length;
            int n2 = 0;
            while (n2 < n) {
                UniversalTagNumber tagNumber = universalTagNumberArray[n2];
                if (tagNumber != null && header.getTagNumber() == tagNumber.getIntValue().intValue()) {
                    foundNumber = tagNumber;
                }
                ++n2;
            }
        }
        if (foundNumber == null) {
            return ParserHelper.parseUnknown(inputStream);
        }
        return ParserHelper.parseTagNumberField(inputStream, foundNumber);
    }

    public static Asn1Field parseTagNumberField(BufferedInputStream inputStream, TagClass tagClass, UniversalTagNumber ... tagNumbers) {
        if (tagClass != TagClass.UNIVERSAL) {
            throw new ParserException("Cannot parse this tag number generically.");
        }
        Asn1Header header = ParserHelper.lookAhead(inputStream);
        UniversalTagNumber foundNumber = null;
        if (header.getTagClass() == tagClass) {
            UniversalTagNumber[] universalTagNumberArray = tagNumbers;
            int n = tagNumbers.length;
            int n2 = 0;
            while (n2 < n) {
                UniversalTagNumber tagNumber = universalTagNumberArray[n2];
                if (header.getTagNumber() == tagNumber.getIntValue().intValue()) {
                    foundNumber = tagNumber;
                }
                ++n2;
            }
        }
        if (foundNumber == null) {
            throw new ParserException("Unexpected tagNumber. Found: " + header.getTagNumber() + " but expected " + Arrays.toString((Object[])tagNumbers));
        }
        return ParserHelper.parseTagNumberField(inputStream, foundNumber);
    }

    public static Asn1Field parseTagNumberField(BufferedInputStream inputStream, UniversalTagNumber tagNumber) {
        switch (tagNumber) {
            case BIT_STRING: {
                Asn1BitString bitstring = new Asn1BitString("bitString");
                ParserHelper.parseAsn1BitString(bitstring, inputStream);
                return bitstring;
            }
            case BOOLEAN: {
                Asn1Boolean asn1Boolean = new Asn1Boolean("boolean");
                ParserHelper.parseAsn1Boolean(asn1Boolean, inputStream);
                return asn1Boolean;
            }
            case GENERALIZEDTIME: {
                Asn1GeneralizedTime asn1GeneralizedTime = new Asn1GeneralizedTime("generalizedTime");
                ParserHelper.parseAsn1GeneralizedTime(asn1GeneralizedTime, inputStream);
                return asn1GeneralizedTime;
            }
            case IA5STRING: {
                Asn1Ia5String asn1Ia5String = new Asn1Ia5String("ia5String");
                ParserHelper.parseAsn1Ia5String(asn1Ia5String, inputStream);
                return asn1Ia5String;
            }
            case INTEGER: {
                Asn1Integer asn1Integer = new Asn1Integer("integer");
                ParserHelper.parseAsn1Integer(asn1Integer, inputStream);
                return asn1Integer;
            }
            case NULL: {
                Asn1Null asn1Null = new Asn1Null("null");
                ParserHelper.parseAsn1Null(asn1Null, inputStream);
                return asn1Null;
            }
            case OCTET_STRING: {
                Asn1OctetString asn1OctetString = new Asn1OctetString("octetString");
                ParserHelper.parseAsn1OctetString(asn1OctetString, inputStream);
                return asn1OctetString;
            }
            case PRINTABLESTRING: {
                Asn1PrintableString asn1PrintableString = new Asn1PrintableString("printableString");
                ParserHelper.parseAsn1PrintableString(asn1PrintableString, inputStream);
                return asn1PrintableString;
            }
            case OBJECT_IDENTIFIER: {
                Asn1ObjectIdentifier asn1ObjectIdentifier = new Asn1ObjectIdentifier("objectIdentifier");
                ParserHelper.parseAsn1ObjectIdentifier(asn1ObjectIdentifier, inputStream);
                return asn1ObjectIdentifier;
            }
            case SEQUENCE: {
                Asn1UnknownSequence asn1UnknownSequence = new Asn1UnknownSequence("sequence");
                ParserHelper.parseStructure(asn1UnknownSequence, inputStream);
                return asn1UnknownSequence;
            }
            case SET: {
                Asn1UnknownSet asn1UnknownSet = new Asn1UnknownSet("set");
                ParserHelper.parseStructure(asn1UnknownSet, inputStream);
                return asn1UnknownSet;
            }
            case T61STRING: {
                Asn1T61String asn1t61String = new Asn1T61String("t61String");
                ParserHelper.parseAsn1T61String(asn1t61String, inputStream);
                return asn1t61String;
            }
            case UTCTIME: {
                Asn1UtcTime asn1UtcTime = new Asn1UtcTime("utcTime");
                ParserHelper.parseAsn1UtcTime(asn1UtcTime, inputStream);
                return asn1UtcTime;
            }
            case UTF8STRING: {
                Asn1Utf8String asn1Utf8String = new Asn1Utf8String("utf8String");
                ParserHelper.parseAsn1Utf8String(asn1Utf8String, inputStream);
                return asn1Utf8String;
            }
        }
        LOGGER.warn("Could theoretically parse tag number {} but this is not implemented yet. Parsing as unknown.", (Object)tagNumber);
        return ParserHelper.parseUnknown(inputStream);
    }

    public static Asn1UnknownField parseUnknown(BufferedInputStream inputStream) {
        Asn1Header asn1Header = ParserHelper.lookAhead(inputStream);
        Asn1UnknownField unknownField = new Asn1UnknownField("unknown", asn1Header.getTagClass(), asn1Header.getTagConstructed(), asn1Header.getTagNumber());
        ParserHelper.parseStructure(unknownField, inputStream);
        return unknownField;
    }

    public static boolean canParse(BufferedInputStream inputStream, TagClass tagClass, int tagNumber) {
        Asn1Header header = ParserHelper.lookAhead(inputStream);
        if (header == null) {
            return false;
        }
        if (header.getTagClass() != tagClass) {
            return false;
        }
        return header.getTagNumber() == tagNumber;
    }

    public static Asn1Header lookAhead(BufferedInputStream inputStream) {
        block3: {
            try {
                LOGGER.debug("Looking ahead...");
                if (inputStream.available() != 0) break block3;
                LOGGER.debug("Cannot look ahead, stream is empty");
                return null;
            }
            catch (IOException e) {
                throw new ParserException("Failed to look ahead.", (Throwable)e);
            }
        }
        inputStream.mark(inputStream.available());
        byte[] tagOctets = ParserHelper.parseTagOctets(inputStream);
        int tagClass = ParserHelper.parseTagClass(tagOctets[0]);
        boolean constructed = ParserHelper.parseTagConstructed(tagOctets[0]);
        int parseTagNumber = ParserHelper.parseTagNumber(tagOctets);
        byte[] lengthOctets = ParserHelper.parseLengthOctets(inputStream);
        BigInteger parseLength = ParserHelper.parseLength(lengthOctets);
        inputStream.reset();
        LOGGER.debug("Reset stream. Back to normal");
        return new Asn1Header(TagClass.fromIntValue(tagClass), parseTagNumber, parseLength, TagConstructed.fromBooleanValue(constructed));
    }

    public static void parseStructure(Asn1Field field, BufferedInputStream stream) {
        try {
            field.setTagOctets(ParserHelper.parseTagOctets(stream));
            field.setTagClass(ParserHelper.parseTagClass(((byte[])field.getTagOctets().getValue())[0]));
            field.setTagConstructed(ParserHelper.parseTagConstructed(((byte[])field.getTagOctets().getValue())[0]));
            field.setTagNumber(ParserHelper.parseTagNumber((byte[])field.getTagOctets().getValue()));
            field.setLengthOctets(ParserHelper.parseLengthOctets(stream));
            field.setLength(ParserHelper.parseLength((byte[])field.getLengthOctets().getValue()));
            field.setContent(ParserHelper.parseContentOctets((BigInteger)field.getLength().getValue(), stream));
            ParserHelper.validateConstants(field);
        }
        catch (IOException ex) {
            throw new ParserException((Throwable)ex);
        }
    }

    public static void parseAsn1Boolean(Asn1Boolean asn1Boolean, BufferedInputStream inputStream) {
        ParserHelper.parseStructure(asn1Boolean, inputStream);
        ParserHelper.parseBooleanContent(asn1Boolean);
    }

    public static void parseAsn1Integer(Asn1Integer asn1Integer, BufferedInputStream inputStream) {
        ParserHelper.parseStructure(asn1Integer, inputStream);
        ParserHelper.parseIntegerContent(asn1Integer);
    }

    public static void parseAsn1Null(Asn1Null asn1Null, BufferedInputStream inputStream) {
        ParserHelper.parseStructure(asn1Null, inputStream);
        ParserHelper.parseNullContent(asn1Null);
    }

    public static void parseAsn1ObjectIdentifier(Asn1ObjectIdentifier asn1ObjectIdentifier, BufferedInputStream inputStream) {
        ParserHelper.parseStructure(asn1ObjectIdentifier, inputStream);
        ParserHelper.parseAsn1ObjectIdentifierContent(asn1ObjectIdentifier);
    }

    public static void parseAsn1BitString(Asn1BitString asn1BitString, BufferedInputStream inputStream) {
        ParserHelper.parseStructure(asn1BitString, inputStream);
        ParserHelper.parseBitStringContent(asn1BitString);
    }

    public static void parseAsn1GeneralizedTime(Asn1GeneralizedTime asn1GeneralizedTime, BufferedInputStream inputStream) {
        ParserHelper.parseStructure(asn1GeneralizedTime, inputStream);
        ParserHelper.parseGeneralizedTimeContent(asn1GeneralizedTime);
    }

    public static void parseAsn1Ia5String(Asn1Ia5String asn1Ia5String, BufferedInputStream inputStream) {
        ParserHelper.parseStructure(asn1Ia5String, inputStream);
        ParserHelper.parseIa5StringContent(asn1Ia5String);
    }

    public static void parseAsn1OctetString(Asn1OctetString asn1OctetString, BufferedInputStream inputStream) {
        ParserHelper.parseStructure(asn1OctetString, inputStream);
        ParserHelper.parseOctetStringContent(asn1OctetString);
    }

    public static void parseAsn1PrintableString(Asn1PrintableString asn1PrintableString, BufferedInputStream inputStream) {
        ParserHelper.parseStructure(asn1PrintableString, inputStream);
        ParserHelper.parsePrintableStringContent(asn1PrintableString);
    }

    public static void parseAsn1T61String(Asn1T61String asn1T61String, BufferedInputStream inputStream) {
        ParserHelper.parseStructure(asn1T61String, inputStream);
        ParserHelper.parseT61StringContent(asn1T61String);
    }

    public static void parseAsn1UtcTime(Asn1UtcTime asn1UtcTime, BufferedInputStream inputStream) {
        ParserHelper.parseStructure(asn1UtcTime, inputStream);
        ParserHelper.parseUtcTimeContent(asn1UtcTime);
    }

    public static void parseAsn1Utf8String(Asn1Utf8String asn1Utf8String, BufferedInputStream inputStream) {
        ParserHelper.parseStructure(asn1Utf8String, inputStream);
        ParserHelper.parseUtf8StringContent(asn1Utf8String);
    }

    public static void parseAsn1ObjectIdentifierContent(Asn1ObjectIdentifier asn1ObjectIdentifier) {
        ObjectIdentifier oid = new ObjectIdentifier((byte[])asn1ObjectIdentifier.getContent().getValue());
        asn1ObjectIdentifier.setValue(oid.toString());
    }

    public static void parseNullContent(Asn1Null asn1Null) {
        if (((byte[])asn1Null.getContent().getValue()).length > 0) {
            throw new ParserException("NullField contains data");
        }
    }

    public static void parseIntegerContent(Asn1Integer asn1Integer) {
        asn1Integer.setValue(new BigInteger((byte[])asn1Integer.getContent().getValue()));
    }

    public static void parseBooleanContent(Asn1Boolean asn1Boolean) {
        if (((byte[])asn1Boolean.getContent().getValue()).length != 1) {
            throw new ParserException("ASN.1 boolean has incorrect size. Expected '1' but found " + ((byte[])asn1Boolean.getContent().getValue()).length);
        }
        if (((byte[])asn1Boolean.getContent().getValue())[0] == -1) {
            asn1Boolean.setValue(true);
        } else if (((byte[])asn1Boolean.getContent().getValue())[0] == 0) {
            asn1Boolean.setValue(false);
        } else {
            LOGGER.warn("asn1Boolean is not DER encoded. Assuming \"false\".");
            asn1Boolean.setValue(false);
        }
    }

    public static void parseBitStringContent(Asn1BitString asn1BitString) {
        if (((byte[])asn1BitString.getContent().getValue()).length == 0) {
            throw new ParserException("No content in Asn1PrimitiveBitString");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream((byte[])asn1BitString.getContent().getValue());
        try {
            asn1BitString.setUnusedBits((byte)((InputStream)inputStream).read());
            byte[] remainingBytes = inputStream.readNBytes(((BigInteger)asn1BitString.getLength().getValue()).intValue() - 1);
            LOGGER.debug("Unused bits: {}", asn1BitString.getUnusedBits().getValue());
            LOGGER.debug("Remaining bytes: {}", (Object)ArrayConverter.bytesToHexString((byte[])remainingBytes));
            asn1BitString.setUsedBits(ParserHelper.shiftRightUnsigned(remainingBytes, ((Byte)asn1BitString.getUnusedBits().getValue()).byteValue()));
            asn1BitString.setPadding(ParserHelper.extractBits(remainingBytes, ((Byte)asn1BitString.getUnusedBits().getValue()).byteValue()));
            LOGGER.debug("Used bits: {}", (Object)ArrayConverter.bytesToHexString((byte[])((byte[])asn1BitString.getUsedBits().getValue())));
            LOGGER.debug("Padding: {}", (Object)ArrayConverter.bytesToHexString((byte[])new byte[]{(Byte)asn1BitString.getPadding().getValue()}));
        }
        catch (IOException e) {
            throw new ParserException("Could not parse BitString", (Throwable)e);
        }
    }

    public static void parseGeneralizedTimeContent(Asn1GeneralizedTime asn1GeneralizedTime) {
        asn1GeneralizedTime.setValue(new String((byte[])asn1GeneralizedTime.getContent().getValue()));
    }

    public static void parseIa5StringContent(Asn1Ia5String asn1Ia5String) {
        asn1Ia5String.setValue(new String((byte[])asn1Ia5String.getContent().getValue()));
    }

    public static void parseOctetStringContent(Asn1OctetString asn1OctetString) {
        asn1OctetString.setValue((byte[])asn1OctetString.getContent().getValue());
    }

    public static void parsePrintableStringContent(Asn1PrintableString asn1PrintableString) {
        asn1PrintableString.setValue(new String((byte[])asn1PrintableString.getContent().getValue()));
    }

    public static void parseT61StringContent(Asn1T61String asn1t61String) {
        asn1t61String.setValue(new String((byte[])asn1t61String.getContent().getValue()));
    }

    public static void parseUtcTimeContent(Asn1UtcTime asn1UtcTime) {
        asn1UtcTime.setValue(new String((byte[])asn1UtcTime.getContent().getValue()));
    }

    public static void parseUtf8StringContent(Asn1Utf8String asn1Utf8String) {
        asn1Utf8String.setValue(new String((byte[])asn1Utf8String.getContent().getValue()));
    }

    private static byte extractBits(byte[] input, int n) {
        if (input.length == 0) {
            return 0;
        }
        if (n > 8) {
            throw new IllegalArgumentException("n must be between 0 and 8, inclusive");
        }
        int mask = (1 << n) - 1;
        return (byte)(input[input.length - 1] & mask);
    }

    private static byte[] shiftRightUnsigned(byte[] array, int n) {
        if (array.length == 0) {
            return array;
        }
        byte[] paddedArray = new byte[array.length + 1];
        paddedArray[0] = 0;
        System.arraycopy(array, 0, paddedArray, 1, array.length);
        BigInteger bigInt = new BigInteger(paddedArray);
        BigInteger shiftInt = bigInt.shiftRight(n);
        byte[] shiftedArray = shiftInt.toByteArray();
        byte[] result = new byte[array.length];
        System.arraycopy(shiftedArray, shiftedArray.length - array.length, result, 0, array.length);
        return result;
    }

    public static byte[] parseTagOctets(BufferedInputStream stream) throws IOException {
        if (stream.available() == 0) {
            throw new ParserException("Cannot read from empty stream");
        }
        int read = stream.read();
        if ((read & 0x1F) == 31) {
            SilentByteArrayOutputStream tagByteStream = new SilentByteArrayOutputStream();
            tagByteStream.write(read);
            do {
                if (stream.available() == 0) {
                    throw new ParserException("Incomplete tag: " + ArrayConverter.bytesToHexString((byte[])tagByteStream.toByteArray()));
                }
                read = stream.read();
                if (read == -1) {
                    throw new ParserException("Incomplete tag: " + ArrayConverter.bytesToHexString((byte[])tagByteStream.toByteArray()));
                }
                tagByteStream.write(read);
            } while ((read & 0x80) > 0);
            LOGGER.debug("Parsed (long) tag octets: {}", (Object)tagByteStream.toByteArray());
            return tagByteStream.toByteArray();
        }
        byte[] tag = new byte[]{(byte)read};
        LOGGER.debug("Parsed short tag octets: {}", (Object)tag);
        return tag;
    }

    public static int parseTagClass(byte firstTagByte) {
        return firstTagByte >> 6 & 3;
    }

    public static boolean parseTagConstructed(byte firstTagByte) {
        return (firstTagByte >> 5 & 1) != 0;
    }

    public static int parseTagNumber(byte[] encodedTag) {
        byte nextByte;
        if (encodedTag.length == 1) {
            return encodedTag[0] & 0x1F;
        }
        int tagNumber = 0;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(encodedTag);
        do {
            nextByte = (byte)(inputStream.read() & 0xFF);
            tagNumber = tagNumber << 7 | nextByte & 0x7F;
        } while ((nextByte & 0x80) > 0 && inputStream.available() > 0);
        return tagNumber;
    }

    public static BigInteger parseLength(byte[] lengthOctets) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(lengthOctets);
        BigInteger length = BigInteger.ZERO;
        byte lengthByte = (byte)(inputStream.read() & 0xFF);
        if (lengthByte == -128) {
            throw new ParserException("Indefinite lengths are currently not supported!");
        }
        if (lengthByte == -1) {
            throw new ParserException("Reserved length value!");
        }
        if ((lengthByte & 0xFF) < 128) {
            length = BigInteger.valueOf(lengthByte & 0xFF);
        } else {
            int numberOfLengthBytes = lengthByte & 0x7F;
            if (inputStream.available() != numberOfLengthBytes) {
                throw new ParserException("Length octets have incorrect length");
            }
            int i = 0;
            while (i < numberOfLengthBytes) {
                length = length.shiftLeft(8);
                length = length.or(BigInteger.valueOf(inputStream.read() & 0xFF));
                ++i;
            }
        }
        return length;
    }

    public static byte[] parseLengthOctets(BufferedInputStream inputStream) throws ParserException, IOException {
        byte lengthByte;
        SilentByteArrayOutputStream outputStream = new SilentByteArrayOutputStream();
        try {
            lengthByte = (byte)(inputStream.read() & 0xFF);
            outputStream.write(lengthByte & 0xFF);
        }
        catch (IOException ex) {
            throw new ParserException((Throwable)ex);
        }
        if (lengthByte == -128) {
            throw new ParserException("Indefinite lengths are currently not supported!");
        }
        if (lengthByte == -1) {
            throw new ParserException("Reserved length value!");
        }
        if ((lengthByte & 0xFF) < 128) {
            LOGGER.debug("Parsed (short) length octets: {}", (Object)outputStream.toByteArray());
            return outputStream.toByteArray();
        }
        int numberOfLengthBytes = lengthByte & 0x7F;
        if (numberOfLengthBytes > inputStream.available()) {
            throw new ParserException("Not enough bytes for length octets in stream");
        }
        int i = 0;
        while (i < numberOfLengthBytes) {
            try {
                outputStream.write(inputStream.read());
            }
            catch (IOException ex) {
                throw new ParserException((Throwable)ex);
            }
            ++i;
        }
        LOGGER.debug("Parsed (long) length octets: {}", (Object)outputStream.toByteArray());
        return outputStream.toByteArray();
    }

    public static byte[] parseContentOctets(BigInteger length, BufferedInputStream inputStream) throws IOException {
        if (inputStream.available() < length.intValue()) {
            throw new ParserException("Not enough bytes in stream");
        }
        byte[] octets = inputStream.readNBytes(length.intValue());
        LOGGER.debug("Parsed content octets: {}", (Object)octets);
        return octets;
    }

    public static void validateConstants(Asn1Field field) {
        if (field.getTagClassType() != null && field.getTagClassType().getIntValue() != ((Integer)field.getTagClass().getValue()).intValue()) {
            TagClass foundTagClass = TagClass.fromIntValue((Integer)field.getTagClass().getValue());
            throw new ParserException("TagClassType did not match expectations expected " + field.getTagClassType().name() + "(" + field.getTagClassType().getIntValue() + ") but found " + (foundTagClass == null ? "???" : foundTagClass.name()) + " (" + String.valueOf(field.getTagClass().getValue()) + ")");
        }
        if (field.getTagConstructedType() != null && field.getTagConstructedType().getBooleanValue() != ((Boolean)field.getTagConstructed().getValue()).booleanValue()) {
            TagConstructed foundTagConstructed = TagConstructed.fromBooleanValue((Boolean)field.getTagConstructed().getValue());
            throw new ParserException("TagConstructedType did not match expectations expected " + field.getTagConstructedType().name() + "(" + field.getTagConstructedType().getBooleanValue() + ") but found " + (foundTagConstructed == null ? "???" : foundTagConstructed.name()) + " (" + String.valueOf(field.getTagConstructed().getValue()) + ")");
        }
        if (field.getUniversalTagNumberType() != null && !Objects.equals(field.getUniversalTagNumberType().getIntValue(), field.getTagNumber().getValue())) {
            UniversalTagNumber foundTagNumber = UniversalTagNumber.fromIntValue((Integer)field.getTagNumber().getValue());
            throw new ParserException("TagNumber did not match expectations expected " + field.getUniversalTagNumberType().name() + "(" + String.valueOf(field.getUniversalTagNumberType().getIntValue()) + ") but found " + (foundTagNumber == null ? "???" : foundTagNumber.name()) + " (" + String.valueOf(field.getTagNumber().getValue()) + ") for " + field.getIdentifier());
        }
    }

    public static void parseGenericField(Asn1Encodable encodable, BufferedInputStream inputStream) {
        if (encodable instanceof Asn1Integer) {
            ParserHelper.parseAsn1Integer((Asn1Integer)encodable, inputStream);
        } else if (encodable instanceof Asn1BitString) {
            ParserHelper.parseAsn1BitString((Asn1BitString)encodable, inputStream);
        } else if (encodable instanceof Asn1Boolean) {
            ParserHelper.parseAsn1Boolean((Asn1Boolean)encodable, inputStream);
        } else if (encodable instanceof Asn1GeneralizedTime) {
            ParserHelper.parseAsn1GeneralizedTime((Asn1GeneralizedTime)encodable, inputStream);
        } else if (encodable instanceof Asn1Ia5String) {
            ParserHelper.parseAsn1Ia5String((Asn1Ia5String)encodable, inputStream);
        } else if (encodable instanceof Asn1Null) {
            ParserHelper.parseAsn1Null((Asn1Null)encodable, inputStream);
        } else if (encodable instanceof Asn1ObjectIdentifier) {
            ParserHelper.parseAsn1ObjectIdentifier((Asn1ObjectIdentifier)encodable, inputStream);
        } else if (encodable instanceof Asn1OctetString) {
            ParserHelper.parseAsn1OctetString((Asn1OctetString)encodable, inputStream);
        } else if (encodable instanceof Asn1PrintableString) {
            ParserHelper.parseAsn1PrintableString((Asn1PrintableString)encodable, inputStream);
        } else if (encodable instanceof Asn1T61String) {
            ParserHelper.parseAsn1T61String((Asn1T61String)encodable, inputStream);
        } else if (encodable instanceof Asn1UtcTime) {
            ParserHelper.parseAsn1UtcTime((Asn1UtcTime)encodable, inputStream);
        } else if (encodable instanceof Asn1Utf8String) {
            ParserHelper.parseAsn1Utf8String((Asn1Utf8String)encodable, inputStream);
        } else {
            ParserHelper.parseStructure((Asn1Field)encodable, inputStream);
        }
    }
}

