/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.model;

import de.rub.nds.asn1.constants.TagClass;
import de.rub.nds.asn1.constants.TagConstructed;
import de.rub.nds.asn1.constants.UniversalTagNumber;
import de.rub.nds.asn1.model.Asn1BitString;
import de.rub.nds.asn1.model.Asn1Boolean;
import de.rub.nds.asn1.model.Asn1Field;
import de.rub.nds.asn1.model.Asn1GeneralizedTime;
import de.rub.nds.asn1.model.Asn1Ia5String;
import de.rub.nds.asn1.model.Asn1Integer;
import de.rub.nds.asn1.model.Asn1Null;
import de.rub.nds.asn1.model.Asn1ObjectIdentifier;
import de.rub.nds.asn1.model.Asn1OctetString;
import de.rub.nds.asn1.model.Asn1PrintableString;
import de.rub.nds.asn1.model.Asn1T61String;
import de.rub.nds.asn1.model.Asn1UnknownField;
import de.rub.nds.asn1.model.Asn1UnknownSequence;
import de.rub.nds.asn1.model.Asn1UnknownSet;
import de.rub.nds.asn1.model.Asn1UtcTime;
import de.rub.nds.asn1.model.Asn1Utf8String;

public class Asn1Factory {
    public Asn1Field createAsn1Element(int tagClassValue, boolean constructedValue, int tagNumberValue) {
        TagClass tagClass = TagClass.fromIntValue(tagClassValue);
        TagConstructed tagConstructed = TagConstructed.fromBooleanValue(constructedValue);
        UniversalTagNumber tagNumber = UniversalTagNumber.fromIntValue(tagNumberValue);
        if (tagClass != TagClass.UNIVERSAL || tagNumber == null) {
            return new Asn1UnknownField("unknownField", tagClass, tagConstructed, tagNumberValue);
        }
        switch (tagNumber) {
            case BIT_STRING: {
                if (tagConstructed == TagConstructed.PRIMITIVE) {
                    return new Asn1BitString("field");
                }
                throw new UnsupportedOperationException("Constructed Asn1BitStrings not supported");
            }
            case BMPSTRING: {
                throw new UnsupportedOperationException("Asn1BmpString not supported");
            }
            case BOOLEAN: {
                if (tagConstructed == TagConstructed.PRIMITIVE) {
                    return new Asn1Boolean("field");
                }
                throw new UnsupportedOperationException("Constructed Asn1Boolean not supported");
            }
            case CHARACTER_STRING: {
                throw new UnsupportedOperationException("Constructed Asn1CharacterString not supported");
            }
            case EMBEDDED_PDV: {
                throw new UnsupportedOperationException("Constructed Asn1EmbeddedPdv not supported");
            }
            case END_OF_CONTENT: {
                throw new UnsupportedOperationException("Constructed Asn1EndOfContent not supported");
            }
            case ENUMERATED: {
                throw new UnsupportedOperationException("Asn1Enumerated not supported");
            }
            case EXTERNAL: {
                throw new UnsupportedOperationException("Constructed Asn1External not supported");
            }
            case GENERALIZEDTIME: {
                if (tagConstructed == TagConstructed.PRIMITIVE) {
                    return new Asn1GeneralizedTime("field");
                }
                throw new UnsupportedOperationException("Constructed Asn1GeneralizedTime not supported");
            }
            case GENERALSTRING: {
                throw new UnsupportedOperationException("Constructed Asn1GeneralString not supported");
            }
            case GRAPHICSTRING: {
                throw new UnsupportedOperationException("Constructed Asn1GraphicString not supported");
            }
            case IA5STRING: {
                if (tagConstructed == TagConstructed.PRIMITIVE) {
                    return new Asn1Ia5String("field");
                }
                throw new UnsupportedOperationException("Constructed Asn1PrimitiveIa5String not supported");
            }
            case INTEGER: {
                if (tagConstructed == TagConstructed.PRIMITIVE) {
                    return new Asn1Integer("field");
                }
                throw new UnsupportedOperationException("Constructed Asn1Integer not supported");
            }
            case NULL: {
                if (tagConstructed == TagConstructed.PRIMITIVE) {
                    return new Asn1Null("field");
                }
                throw new UnsupportedOperationException("Constructed Asn1Null not supported");
            }
            case NUMERICSTRING: {
                throw new UnsupportedOperationException("Constructed Asn1NumericString not supported");
            }
            case OBJECT_DESCRIPTOR: {
                throw new UnsupportedOperationException("Constructed Asn1ObjectDescriptor not supported");
            }
            case OBJECT_IDENTIFIER: {
                if (tagConstructed == TagConstructed.PRIMITIVE) {
                    return new Asn1ObjectIdentifier("field");
                }
                throw new UnsupportedOperationException("Constructed Asn1ObjectIdentifier not supported");
            }
            case OCTET_STRING: {
                if (tagConstructed == TagConstructed.PRIMITIVE) {
                    return new Asn1OctetString("field");
                }
                throw new UnsupportedOperationException("Constructed Asn1PrimitiveOctetString not supported");
            }
            case PRINTABLESTRING: {
                if (tagConstructed == TagConstructed.PRIMITIVE) {
                    return new Asn1PrintableString("field");
                }
                throw new UnsupportedOperationException("Constructed Asn1PrimitiveOctetString not supported");
            }
            case REAL: {
                throw new UnsupportedOperationException("Constructed Asn1Real not supported");
            }
            case RELATIVE_OID: {
                throw new UnsupportedOperationException("Constructed Asn1RelativeOid not supported");
            }
            case SEQUENCE: {
                return new Asn1UnknownSequence("field");
            }
            case SET: {
                return new Asn1UnknownSet("field");
            }
            case T61STRING: {
                if (tagConstructed == TagConstructed.PRIMITIVE) {
                    return new Asn1T61String("field");
                }
                throw new UnsupportedOperationException("Constructed Asn1PrimitiveT61String not supported");
            }
            case UNIVERSALSTRING: {
                throw new UnsupportedOperationException("Constructed Asn1UniversalString not supported");
            }
            case UTCTIME: {
                if (tagConstructed == TagConstructed.PRIMITIVE) {
                    return new Asn1UtcTime("field");
                }
                throw new UnsupportedOperationException("Constructed Asn1PrimitiveUtcTime not supported");
            }
            case UTF8STRING: {
                if (tagConstructed == TagConstructed.PRIMITIVE) {
                    return new Asn1Utf8String("field");
                }
                throw new UnsupportedOperationException("Constructed Asn1PrimitiveUtf8String not supported");
            }
            case VIDEOTEXSTRING: {
                throw new UnsupportedOperationException("Constructed Asn1VideoTexString not supported");
            }
            case VISIBLESTRING: {
                throw new UnsupportedOperationException("Constructed Asn1VisibleString not supported");
            }
        }
        return new Asn1UnknownField("unknownField", tagClass, tagConstructed, tagNumberValue);
    }
}

